/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.HubVirtualNetworkConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.HubVirtualNetworkConnectionInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ListHubVirtualNetworkConnectionsResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class HubVirtualNetworkConnectionsClientImpl
implements HubVirtualNetworkConnectionsClient {
    private final ClientLogger logger = new ClientLogger(HubVirtualNetworkConnectionsClientImpl.class);
    private final HubVirtualNetworkConnectionsService service;
    private final NetworkManagementClientImpl client;

    HubVirtualNetworkConnectionsClientImpl(NetworkManagementClientImpl client) {
        this.service = (HubVirtualNetworkConnectionsService)RestProxy.create(HubVirtualNetworkConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (hubVirtualNetworkConnectionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hubVirtualNetworkConnectionParameters is required and cannot be null."));
        }
        hubVirtualNetworkConnectionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", hubVirtualNetworkConnectionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (hubVirtualNetworkConnectionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hubVirtualNetworkConnectionParameters is required and cannot be null."));
        }
        hubVirtualNetworkConnectionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", hubVirtualNetworkConnectionParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<HubVirtualNetworkConnectionInner>, HubVirtualNetworkConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)HubVirtualNetworkConnectionInner.class), (Type)((Object)HubVirtualNetworkConnectionInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<HubVirtualNetworkConnectionInner>, HubVirtualNetworkConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)HubVirtualNetworkConnectionInner.class), (Type)((Object)HubVirtualNetworkConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<HubVirtualNetworkConnectionInner>, HubVirtualNetworkConnectionInner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<HubVirtualNetworkConnectionInner>, HubVirtualNetworkConnectionInner> beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HubVirtualNetworkConnectionInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HubVirtualNetworkConnectionInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HubVirtualNetworkConnectionInner createOrUpdate(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters) {
        return (HubVirtualNetworkConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HubVirtualNetworkConnectionInner createOrUpdate(String resourceGroupName, String virtualHubName, String connectionName, HubVirtualNetworkConnectionInner hubVirtualNetworkConnectionParameters, Context context) {
        return (HubVirtualNetworkConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualHubName, connectionName, hubVirtualNetworkConnectionParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, connectionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualHubName, connectionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String connectionName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, connectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, connectionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, connectionName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, connectionName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String connectionName) {
        this.deleteAsync(resourceGroupName, virtualHubName, connectionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        this.deleteAsync(resourceGroupName, virtualHubName, connectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HubVirtualNetworkConnectionInner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HubVirtualNetworkConnectionInner>> getWithResponseAsync(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, connectionName, "2021-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HubVirtualNetworkConnectionInner> getAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        return this.getWithResponseAsync(resourceGroupName, virtualHubName, connectionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HubVirtualNetworkConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HubVirtualNetworkConnectionInner get(String resourceGroupName, String virtualHubName, String connectionName) {
        return (HubVirtualNetworkConnectionInner)((Object)this.getAsync(resourceGroupName, virtualHubName, connectionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HubVirtualNetworkConnectionInner> getWithResponse(String resourceGroupName, String virtualHubName, String connectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, virtualHubName, connectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HubVirtualNetworkConnectionInner>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2021-03-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).value(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HubVirtualNetworkConnectionInner>> listSinglePageAsync(String resourceGroupName, String virtualHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualHubName, "2021-03-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).value(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HubVirtualNetworkConnectionInner> listAsync(String resourceGroupName, String virtualHubName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HubVirtualNetworkConnectionInner> listAsync(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualHubName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HubVirtualNetworkConnectionInner> list(String resourceGroupName, String virtualHubName) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HubVirtualNetworkConnectionInner> list(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualHubName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HubVirtualNetworkConnectionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).value(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HubVirtualNetworkConnectionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).value(), ((ListHubVirtualNetworkConnectionsResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface HubVirtualNetworkConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") HubVirtualNetworkConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HubVirtualNetworkConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListHubVirtualNetworkConnectionsResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualHubName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListHubVirtualNetworkConnectionsResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

