/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.fluent.models.AttestationProperties;
import com.azure.resourcemanager.policyinsights.models.AttestationEvidence;
import com.azure.resourcemanager.policyinsights.models.ComplianceState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AttestationInner
extends ProxyResource {
    private AttestationProperties innerProperties = new AttestationProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(AttestationInner.class);

    private AttestationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String policyAssignmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyAssignmentId();
    }

    public AttestationInner withPolicyAssignmentId(String policyAssignmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withPolicyAssignmentId(policyAssignmentId);
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionReferenceId();
    }

    public AttestationInner withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withPolicyDefinitionReferenceId(policyDefinitionReferenceId);
        return this;
    }

    public ComplianceState complianceState() {
        return this.innerProperties() == null ? null : this.innerProperties().complianceState();
    }

    public AttestationInner withComplianceState(ComplianceState complianceState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withComplianceState(complianceState);
        return this;
    }

    public OffsetDateTime expiresOn() {
        return this.innerProperties() == null ? null : this.innerProperties().expiresOn();
    }

    public AttestationInner withExpiresOn(OffsetDateTime expiresOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withExpiresOn(expiresOn);
        return this;
    }

    public String owner() {
        return this.innerProperties() == null ? null : this.innerProperties().owner();
    }

    public AttestationInner withOwner(String owner) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withOwner(owner);
        return this;
    }

    public String comments() {
        return this.innerProperties() == null ? null : this.innerProperties().comments();
    }

    public AttestationInner withComments(String comments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withComments(comments);
        return this;
    }

    public List<AttestationEvidence> evidence() {
        return this.innerProperties() == null ? null : this.innerProperties().evidence();
    }

    public AttestationInner withEvidence(List<AttestationEvidence> evidence) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withEvidence(evidence);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime lastComplianceStateChangeAt() {
        return this.innerProperties() == null ? null : this.innerProperties().lastComplianceStateChangeAt();
    }

    public OffsetDateTime assessmentDate() {
        return this.innerProperties() == null ? null : this.innerProperties().assessmentDate();
    }

    public AttestationInner withAssessmentDate(OffsetDateTime assessmentDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withAssessmentDate(assessmentDate);
        return this;
    }

    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public AttestationInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttestationProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AttestationInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AttestationInner fromJson(JsonReader jsonReader) throws IOException {
        return (AttestationInner)((Object)jsonReader.readObject(reader -> {
            AttestationInner deserializedAttestationInner = new AttestationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAttestationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAttestationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAttestationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAttestationInner.innerProperties = AttestationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAttestationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttestationInner;
        }));
    }
}

