/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.AttestationEvidence;
import com.azure.resourcemanager.policyinsights.models.ComplianceState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AttestationProperties
implements JsonSerializable<AttestationProperties> {
    private String policyAssignmentId;
    private String policyDefinitionReferenceId;
    private ComplianceState complianceState;
    private OffsetDateTime expiresOn;
    private String owner;
    private String comments;
    private List<AttestationEvidence> evidence;
    private String provisioningState;
    private OffsetDateTime lastComplianceStateChangeAt;
    private OffsetDateTime assessmentDate;
    private Object metadata;
    private static final ClientLogger LOGGER = new ClientLogger(AttestationProperties.class);

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public AttestationProperties withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public AttestationProperties withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public ComplianceState complianceState() {
        return this.complianceState;
    }

    public AttestationProperties withComplianceState(ComplianceState complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    public AttestationProperties withExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public String owner() {
        return this.owner;
    }

    public AttestationProperties withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String comments() {
        return this.comments;
    }

    public AttestationProperties withComments(String comments) {
        this.comments = comments;
        return this;
    }

    public List<AttestationEvidence> evidence() {
        return this.evidence;
    }

    public AttestationProperties withEvidence(List<AttestationEvidence> evidence) {
        this.evidence = evidence;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime lastComplianceStateChangeAt() {
        return this.lastComplianceStateChangeAt;
    }

    public OffsetDateTime assessmentDate() {
        return this.assessmentDate;
    }

    public AttestationProperties withAssessmentDate(OffsetDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public AttestationProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.policyAssignmentId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyAssignmentId in model AttestationProperties"));
        }
        if (this.evidence() != null) {
            this.evidence().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("complianceState", this.complianceState == null ? null : this.complianceState.toString());
        jsonWriter.writeStringField("expiresOn", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeStringField("owner", this.owner);
        jsonWriter.writeStringField("comments", this.comments);
        jsonWriter.writeArrayField("evidence", this.evidence, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("assessmentDate", this.assessmentDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.assessmentDate));
        jsonWriter.writeUntypedField("metadata", this.metadata);
        return jsonWriter.writeEndObject();
    }

    public static AttestationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AttestationProperties)jsonReader.readObject(reader -> {
            AttestationProperties deserializedAttestationProperties = new AttestationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedAttestationProperties.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedAttestationProperties.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedAttestationProperties.complianceState = ComplianceState.fromString(reader.getString());
                    continue;
                }
                if ("expiresOn".equals(fieldName)) {
                    deserializedAttestationProperties.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("owner".equals(fieldName)) {
                    deserializedAttestationProperties.owner = reader.getString();
                    continue;
                }
                if ("comments".equals(fieldName)) {
                    deserializedAttestationProperties.comments = reader.getString();
                    continue;
                }
                if ("evidence".equals(fieldName)) {
                    List evidence;
                    deserializedAttestationProperties.evidence = evidence = reader.readArray(reader1 -> AttestationEvidence.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAttestationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("lastComplianceStateChangeAt".equals(fieldName)) {
                    deserializedAttestationProperties.lastComplianceStateChangeAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("assessmentDate".equals(fieldName)) {
                    deserializedAttestationProperties.assessmentDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedAttestationProperties.metadata = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttestationProperties;
        });
    }
}

