/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.Operation;
import java.io.IOException;
import java.util.List;

public final class OperationsListResultsInner
implements JsonSerializable<OperationsListResultsInner> {
    private Integer odataCount;
    private List<Operation> value;

    public Integer odataCount() {
        return this.odataCount;
    }

    public OperationsListResultsInner withOdataCount(Integer odataCount) {
        this.odataCount = odataCount;
        return this;
    }

    public List<Operation> value() {
        return this.value;
    }

    public OperationsListResultsInner withValue(List<Operation> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("@odata.count", (Number)this.odataCount);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationsListResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsListResultsInner)jsonReader.readObject(reader -> {
            OperationsListResultsInner deserializedOperationsListResultsInner = new OperationsListResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.count".equals(fieldName)) {
                    deserializedOperationsListResultsInner.odataCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOperationsListResultsInner.value = value = reader.readArray(reader1 -> Operation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsListResultsInner;
        });
    }
}

