/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.ComponentEventDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PolicyEventInner
implements JsonSerializable<PolicyEventInner> {
    private String odataId;
    private String odataContext;
    private OffsetDateTime timestamp;
    private String resourceId;
    private String policyAssignmentId;
    private String policyDefinitionId;
    private String effectiveParameters;
    private Boolean isCompliant;
    private String subscriptionId;
    private String resourceType;
    private String resourceLocation;
    private String resourceGroup;
    private String resourceTags;
    private String policyAssignmentName;
    private String policyAssignmentOwner;
    private String policyAssignmentParameters;
    private String policyAssignmentScope;
    private String policyDefinitionName;
    private String policyDefinitionAction;
    private String policyDefinitionCategory;
    private String policySetDefinitionId;
    private String policySetDefinitionName;
    private String policySetDefinitionOwner;
    private String policySetDefinitionCategory;
    private String policySetDefinitionParameters;
    private String managementGroupIds;
    private String policyDefinitionReferenceId;
    private String complianceState;
    private String tenantId;
    private String principalOid;
    private List<ComponentEventDetails> components;
    private Map<String, Object> additionalProperties;

    public String odataId() {
        return this.odataId;
    }

    public PolicyEventInner withOdataId(String odataId) {
        this.odataId = odataId;
        return this;
    }

    public String odataContext() {
        return this.odataContext;
    }

    public PolicyEventInner withOdataContext(String odataContext) {
        this.odataContext = odataContext;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public PolicyEventInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public PolicyEventInner withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public PolicyEventInner withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyEventInner withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String effectiveParameters() {
        return this.effectiveParameters;
    }

    public PolicyEventInner withEffectiveParameters(String effectiveParameters) {
        this.effectiveParameters = effectiveParameters;
        return this;
    }

    public Boolean isCompliant() {
        return this.isCompliant;
    }

    public PolicyEventInner withIsCompliant(Boolean isCompliant) {
        this.isCompliant = isCompliant;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public PolicyEventInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public PolicyEventInner withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public PolicyEventInner withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public PolicyEventInner withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String resourceTags() {
        return this.resourceTags;
    }

    public PolicyEventInner withResourceTags(String resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public String policyAssignmentName() {
        return this.policyAssignmentName;
    }

    public PolicyEventInner withPolicyAssignmentName(String policyAssignmentName) {
        this.policyAssignmentName = policyAssignmentName;
        return this;
    }

    public String policyAssignmentOwner() {
        return this.policyAssignmentOwner;
    }

    public PolicyEventInner withPolicyAssignmentOwner(String policyAssignmentOwner) {
        this.policyAssignmentOwner = policyAssignmentOwner;
        return this;
    }

    public String policyAssignmentParameters() {
        return this.policyAssignmentParameters;
    }

    public PolicyEventInner withPolicyAssignmentParameters(String policyAssignmentParameters) {
        this.policyAssignmentParameters = policyAssignmentParameters;
        return this;
    }

    public String policyAssignmentScope() {
        return this.policyAssignmentScope;
    }

    public PolicyEventInner withPolicyAssignmentScope(String policyAssignmentScope) {
        this.policyAssignmentScope = policyAssignmentScope;
        return this;
    }

    public String policyDefinitionName() {
        return this.policyDefinitionName;
    }

    public PolicyEventInner withPolicyDefinitionName(String policyDefinitionName) {
        this.policyDefinitionName = policyDefinitionName;
        return this;
    }

    public String policyDefinitionAction() {
        return this.policyDefinitionAction;
    }

    public PolicyEventInner withPolicyDefinitionAction(String policyDefinitionAction) {
        this.policyDefinitionAction = policyDefinitionAction;
        return this;
    }

    public String policyDefinitionCategory() {
        return this.policyDefinitionCategory;
    }

    public PolicyEventInner withPolicyDefinitionCategory(String policyDefinitionCategory) {
        this.policyDefinitionCategory = policyDefinitionCategory;
        return this;
    }

    public String policySetDefinitionId() {
        return this.policySetDefinitionId;
    }

    public PolicyEventInner withPolicySetDefinitionId(String policySetDefinitionId) {
        this.policySetDefinitionId = policySetDefinitionId;
        return this;
    }

    public String policySetDefinitionName() {
        return this.policySetDefinitionName;
    }

    public PolicyEventInner withPolicySetDefinitionName(String policySetDefinitionName) {
        this.policySetDefinitionName = policySetDefinitionName;
        return this;
    }

    public String policySetDefinitionOwner() {
        return this.policySetDefinitionOwner;
    }

    public PolicyEventInner withPolicySetDefinitionOwner(String policySetDefinitionOwner) {
        this.policySetDefinitionOwner = policySetDefinitionOwner;
        return this;
    }

    public String policySetDefinitionCategory() {
        return this.policySetDefinitionCategory;
    }

    public PolicyEventInner withPolicySetDefinitionCategory(String policySetDefinitionCategory) {
        this.policySetDefinitionCategory = policySetDefinitionCategory;
        return this;
    }

    public String policySetDefinitionParameters() {
        return this.policySetDefinitionParameters;
    }

    public PolicyEventInner withPolicySetDefinitionParameters(String policySetDefinitionParameters) {
        this.policySetDefinitionParameters = policySetDefinitionParameters;
        return this;
    }

    public String managementGroupIds() {
        return this.managementGroupIds;
    }

    public PolicyEventInner withManagementGroupIds(String managementGroupIds) {
        this.managementGroupIds = managementGroupIds;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyEventInner withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public String complianceState() {
        return this.complianceState;
    }

    public PolicyEventInner withComplianceState(String complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public PolicyEventInner withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String principalOid() {
        return this.principalOid;
    }

    public PolicyEventInner withPrincipalOid(String principalOid) {
        this.principalOid = principalOid;
        return this;
    }

    public List<ComponentEventDetails> components() {
        return this.components;
    }

    public PolicyEventInner withComponents(List<ComponentEventDetails> components) {
        this.components = components;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public PolicyEventInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.components() != null) {
            this.components().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.id", this.odataId);
        jsonWriter.writeStringField("@odata.context", this.odataContext);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("effectiveParameters", this.effectiveParameters);
        jsonWriter.writeBooleanField("isCompliant", this.isCompliant);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceTags", this.resourceTags);
        jsonWriter.writeStringField("policyAssignmentName", this.policyAssignmentName);
        jsonWriter.writeStringField("policyAssignmentOwner", this.policyAssignmentOwner);
        jsonWriter.writeStringField("policyAssignmentParameters", this.policyAssignmentParameters);
        jsonWriter.writeStringField("policyAssignmentScope", this.policyAssignmentScope);
        jsonWriter.writeStringField("policyDefinitionName", this.policyDefinitionName);
        jsonWriter.writeStringField("policyDefinitionAction", this.policyDefinitionAction);
        jsonWriter.writeStringField("policyDefinitionCategory", this.policyDefinitionCategory);
        jsonWriter.writeStringField("policySetDefinitionId", this.policySetDefinitionId);
        jsonWriter.writeStringField("policySetDefinitionName", this.policySetDefinitionName);
        jsonWriter.writeStringField("policySetDefinitionOwner", this.policySetDefinitionOwner);
        jsonWriter.writeStringField("policySetDefinitionCategory", this.policySetDefinitionCategory);
        jsonWriter.writeStringField("policySetDefinitionParameters", this.policySetDefinitionParameters);
        jsonWriter.writeStringField("managementGroupIds", this.managementGroupIds);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("complianceState", this.complianceState);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("principalOid", this.principalOid);
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PolicyEventInner fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyEventInner)jsonReader.readObject(reader -> {
            PolicyEventInner deserializedPolicyEventInner = new PolicyEventInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.id".equals(fieldName)) {
                    deserializedPolicyEventInner.odataId = reader.getString();
                    continue;
                }
                if ("@odata.context".equals(fieldName)) {
                    deserializedPolicyEventInner.odataContext = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedPolicyEventInner.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedPolicyEventInner.resourceId = reader.getString();
                    continue;
                }
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyEventInner.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyEventInner.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("effectiveParameters".equals(fieldName)) {
                    deserializedPolicyEventInner.effectiveParameters = reader.getString();
                    continue;
                }
                if ("isCompliant".equals(fieldName)) {
                    deserializedPolicyEventInner.isCompliant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedPolicyEventInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedPolicyEventInner.resourceType = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedPolicyEventInner.resourceLocation = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedPolicyEventInner.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    deserializedPolicyEventInner.resourceTags = reader.getString();
                    continue;
                }
                if ("policyAssignmentName".equals(fieldName)) {
                    deserializedPolicyEventInner.policyAssignmentName = reader.getString();
                    continue;
                }
                if ("policyAssignmentOwner".equals(fieldName)) {
                    deserializedPolicyEventInner.policyAssignmentOwner = reader.getString();
                    continue;
                }
                if ("policyAssignmentParameters".equals(fieldName)) {
                    deserializedPolicyEventInner.policyAssignmentParameters = reader.getString();
                    continue;
                }
                if ("policyAssignmentScope".equals(fieldName)) {
                    deserializedPolicyEventInner.policyAssignmentScope = reader.getString();
                    continue;
                }
                if ("policyDefinitionName".equals(fieldName)) {
                    deserializedPolicyEventInner.policyDefinitionName = reader.getString();
                    continue;
                }
                if ("policyDefinitionAction".equals(fieldName)) {
                    deserializedPolicyEventInner.policyDefinitionAction = reader.getString();
                    continue;
                }
                if ("policyDefinitionCategory".equals(fieldName)) {
                    deserializedPolicyEventInner.policyDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionId".equals(fieldName)) {
                    deserializedPolicyEventInner.policySetDefinitionId = reader.getString();
                    continue;
                }
                if ("policySetDefinitionName".equals(fieldName)) {
                    deserializedPolicyEventInner.policySetDefinitionName = reader.getString();
                    continue;
                }
                if ("policySetDefinitionOwner".equals(fieldName)) {
                    deserializedPolicyEventInner.policySetDefinitionOwner = reader.getString();
                    continue;
                }
                if ("policySetDefinitionCategory".equals(fieldName)) {
                    deserializedPolicyEventInner.policySetDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionParameters".equals(fieldName)) {
                    deserializedPolicyEventInner.policySetDefinitionParameters = reader.getString();
                    continue;
                }
                if ("managementGroupIds".equals(fieldName)) {
                    deserializedPolicyEventInner.managementGroupIds = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyEventInner.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedPolicyEventInner.complianceState = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedPolicyEventInner.tenantId = reader.getString();
                    continue;
                }
                if ("principalOid".equals(fieldName)) {
                    deserializedPolicyEventInner.principalOid = reader.getString();
                    continue;
                }
                if ("components".equals(fieldName)) {
                    List components;
                    deserializedPolicyEventInner.components = components = reader.readArray(reader1 -> ComponentEventDetails.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPolicyEventInner.additionalProperties = additionalProperties;
            return deserializedPolicyEventInner;
        });
    }
}

