/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.ComponentStateDetails;
import com.azure.resourcemanager.policyinsights.models.PolicyEvaluationDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PolicyStateInner
implements JsonSerializable<PolicyStateInner> {
    private String odataId;
    private String odataContext;
    private OffsetDateTime timestamp;
    private String resourceId;
    private String policyAssignmentId;
    private String policyDefinitionId;
    private String effectiveParameters;
    private Boolean isCompliant;
    private String subscriptionId;
    private String resourceType;
    private String resourceLocation;
    private String resourceGroup;
    private String resourceTags;
    private String policyAssignmentName;
    private String policyAssignmentOwner;
    private String policyAssignmentParameters;
    private String policyAssignmentScope;
    private String policyDefinitionName;
    private String policyDefinitionAction;
    private String policyDefinitionCategory;
    private String policySetDefinitionId;
    private String policySetDefinitionName;
    private String policySetDefinitionOwner;
    private String policySetDefinitionCategory;
    private String policySetDefinitionParameters;
    private String managementGroupIds;
    private String policyDefinitionReferenceId;
    private String complianceState;
    private PolicyEvaluationDetails policyEvaluationDetails;
    private List<String> policyDefinitionGroupNames;
    private List<ComponentStateDetails> components;
    private String policyDefinitionVersion;
    private String policySetDefinitionVersion;
    private String policyAssignmentVersion;
    private Map<String, Object> additionalProperties;

    public String odataId() {
        return this.odataId;
    }

    public PolicyStateInner withOdataId(String odataId) {
        this.odataId = odataId;
        return this;
    }

    public String odataContext() {
        return this.odataContext;
    }

    public PolicyStateInner withOdataContext(String odataContext) {
        this.odataContext = odataContext;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public PolicyStateInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public PolicyStateInner withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public PolicyStateInner withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyStateInner withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String effectiveParameters() {
        return this.effectiveParameters;
    }

    public PolicyStateInner withEffectiveParameters(String effectiveParameters) {
        this.effectiveParameters = effectiveParameters;
        return this;
    }

    public Boolean isCompliant() {
        return this.isCompliant;
    }

    public PolicyStateInner withIsCompliant(Boolean isCompliant) {
        this.isCompliant = isCompliant;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public PolicyStateInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public PolicyStateInner withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public PolicyStateInner withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public PolicyStateInner withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String resourceTags() {
        return this.resourceTags;
    }

    public PolicyStateInner withResourceTags(String resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public String policyAssignmentName() {
        return this.policyAssignmentName;
    }

    public PolicyStateInner withPolicyAssignmentName(String policyAssignmentName) {
        this.policyAssignmentName = policyAssignmentName;
        return this;
    }

    public String policyAssignmentOwner() {
        return this.policyAssignmentOwner;
    }

    public PolicyStateInner withPolicyAssignmentOwner(String policyAssignmentOwner) {
        this.policyAssignmentOwner = policyAssignmentOwner;
        return this;
    }

    public String policyAssignmentParameters() {
        return this.policyAssignmentParameters;
    }

    public PolicyStateInner withPolicyAssignmentParameters(String policyAssignmentParameters) {
        this.policyAssignmentParameters = policyAssignmentParameters;
        return this;
    }

    public String policyAssignmentScope() {
        return this.policyAssignmentScope;
    }

    public PolicyStateInner withPolicyAssignmentScope(String policyAssignmentScope) {
        this.policyAssignmentScope = policyAssignmentScope;
        return this;
    }

    public String policyDefinitionName() {
        return this.policyDefinitionName;
    }

    public PolicyStateInner withPolicyDefinitionName(String policyDefinitionName) {
        this.policyDefinitionName = policyDefinitionName;
        return this;
    }

    public String policyDefinitionAction() {
        return this.policyDefinitionAction;
    }

    public PolicyStateInner withPolicyDefinitionAction(String policyDefinitionAction) {
        this.policyDefinitionAction = policyDefinitionAction;
        return this;
    }

    public String policyDefinitionCategory() {
        return this.policyDefinitionCategory;
    }

    public PolicyStateInner withPolicyDefinitionCategory(String policyDefinitionCategory) {
        this.policyDefinitionCategory = policyDefinitionCategory;
        return this;
    }

    public String policySetDefinitionId() {
        return this.policySetDefinitionId;
    }

    public PolicyStateInner withPolicySetDefinitionId(String policySetDefinitionId) {
        this.policySetDefinitionId = policySetDefinitionId;
        return this;
    }

    public String policySetDefinitionName() {
        return this.policySetDefinitionName;
    }

    public PolicyStateInner withPolicySetDefinitionName(String policySetDefinitionName) {
        this.policySetDefinitionName = policySetDefinitionName;
        return this;
    }

    public String policySetDefinitionOwner() {
        return this.policySetDefinitionOwner;
    }

    public PolicyStateInner withPolicySetDefinitionOwner(String policySetDefinitionOwner) {
        this.policySetDefinitionOwner = policySetDefinitionOwner;
        return this;
    }

    public String policySetDefinitionCategory() {
        return this.policySetDefinitionCategory;
    }

    public PolicyStateInner withPolicySetDefinitionCategory(String policySetDefinitionCategory) {
        this.policySetDefinitionCategory = policySetDefinitionCategory;
        return this;
    }

    public String policySetDefinitionParameters() {
        return this.policySetDefinitionParameters;
    }

    public PolicyStateInner withPolicySetDefinitionParameters(String policySetDefinitionParameters) {
        this.policySetDefinitionParameters = policySetDefinitionParameters;
        return this;
    }

    public String managementGroupIds() {
        return this.managementGroupIds;
    }

    public PolicyStateInner withManagementGroupIds(String managementGroupIds) {
        this.managementGroupIds = managementGroupIds;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyStateInner withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public String complianceState() {
        return this.complianceState;
    }

    public PolicyStateInner withComplianceState(String complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public PolicyEvaluationDetails policyEvaluationDetails() {
        return this.policyEvaluationDetails;
    }

    public PolicyStateInner withPolicyEvaluationDetails(PolicyEvaluationDetails policyEvaluationDetails) {
        this.policyEvaluationDetails = policyEvaluationDetails;
        return this;
    }

    public List<String> policyDefinitionGroupNames() {
        return this.policyDefinitionGroupNames;
    }

    public PolicyStateInner withPolicyDefinitionGroupNames(List<String> policyDefinitionGroupNames) {
        this.policyDefinitionGroupNames = policyDefinitionGroupNames;
        return this;
    }

    public List<ComponentStateDetails> components() {
        return this.components;
    }

    public PolicyStateInner withComponents(List<ComponentStateDetails> components) {
        this.components = components;
        return this;
    }

    public String policyDefinitionVersion() {
        return this.policyDefinitionVersion;
    }

    public String policySetDefinitionVersion() {
        return this.policySetDefinitionVersion;
    }

    public String policyAssignmentVersion() {
        return this.policyAssignmentVersion;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public PolicyStateInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.policyEvaluationDetails() != null) {
            this.policyEvaluationDetails().validate();
        }
        if (this.components() != null) {
            this.components().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.id", this.odataId);
        jsonWriter.writeStringField("@odata.context", this.odataContext);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("effectiveParameters", this.effectiveParameters);
        jsonWriter.writeBooleanField("isCompliant", this.isCompliant);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceTags", this.resourceTags);
        jsonWriter.writeStringField("policyAssignmentName", this.policyAssignmentName);
        jsonWriter.writeStringField("policyAssignmentOwner", this.policyAssignmentOwner);
        jsonWriter.writeStringField("policyAssignmentParameters", this.policyAssignmentParameters);
        jsonWriter.writeStringField("policyAssignmentScope", this.policyAssignmentScope);
        jsonWriter.writeStringField("policyDefinitionName", this.policyDefinitionName);
        jsonWriter.writeStringField("policyDefinitionAction", this.policyDefinitionAction);
        jsonWriter.writeStringField("policyDefinitionCategory", this.policyDefinitionCategory);
        jsonWriter.writeStringField("policySetDefinitionId", this.policySetDefinitionId);
        jsonWriter.writeStringField("policySetDefinitionName", this.policySetDefinitionName);
        jsonWriter.writeStringField("policySetDefinitionOwner", this.policySetDefinitionOwner);
        jsonWriter.writeStringField("policySetDefinitionCategory", this.policySetDefinitionCategory);
        jsonWriter.writeStringField("policySetDefinitionParameters", this.policySetDefinitionParameters);
        jsonWriter.writeStringField("managementGroupIds", this.managementGroupIds);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("complianceState", this.complianceState);
        jsonWriter.writeJsonField("policyEvaluationDetails", (JsonSerializable)this.policyEvaluationDetails);
        jsonWriter.writeArrayField("policyDefinitionGroupNames", this.policyDefinitionGroupNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PolicyStateInner fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyStateInner)jsonReader.readObject(reader -> {
            PolicyStateInner deserializedPolicyStateInner = new PolicyStateInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.id".equals(fieldName)) {
                    deserializedPolicyStateInner.odataId = reader.getString();
                    continue;
                }
                if ("@odata.context".equals(fieldName)) {
                    deserializedPolicyStateInner.odataContext = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedPolicyStateInner.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedPolicyStateInner.resourceId = reader.getString();
                    continue;
                }
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("effectiveParameters".equals(fieldName)) {
                    deserializedPolicyStateInner.effectiveParameters = reader.getString();
                    continue;
                }
                if ("isCompliant".equals(fieldName)) {
                    deserializedPolicyStateInner.isCompliant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedPolicyStateInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedPolicyStateInner.resourceType = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedPolicyStateInner.resourceLocation = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedPolicyStateInner.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    deserializedPolicyStateInner.resourceTags = reader.getString();
                    continue;
                }
                if ("policyAssignmentName".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentName = reader.getString();
                    continue;
                }
                if ("policyAssignmentOwner".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentOwner = reader.getString();
                    continue;
                }
                if ("policyAssignmentParameters".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentParameters = reader.getString();
                    continue;
                }
                if ("policyAssignmentScope".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentScope = reader.getString();
                    continue;
                }
                if ("policyDefinitionName".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionName = reader.getString();
                    continue;
                }
                if ("policyDefinitionAction".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionAction = reader.getString();
                    continue;
                }
                if ("policyDefinitionCategory".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionId".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionId = reader.getString();
                    continue;
                }
                if ("policySetDefinitionName".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionName = reader.getString();
                    continue;
                }
                if ("policySetDefinitionOwner".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionOwner = reader.getString();
                    continue;
                }
                if ("policySetDefinitionCategory".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionParameters".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionParameters = reader.getString();
                    continue;
                }
                if ("managementGroupIds".equals(fieldName)) {
                    deserializedPolicyStateInner.managementGroupIds = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedPolicyStateInner.complianceState = reader.getString();
                    continue;
                }
                if ("policyEvaluationDetails".equals(fieldName)) {
                    deserializedPolicyStateInner.policyEvaluationDetails = PolicyEvaluationDetails.fromJson(reader);
                    continue;
                }
                if ("policyDefinitionGroupNames".equals(fieldName)) {
                    List policyDefinitionGroupNames;
                    deserializedPolicyStateInner.policyDefinitionGroupNames = policyDefinitionGroupNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("components".equals(fieldName)) {
                    List components;
                    deserializedPolicyStateInner.components = components = reader.readArray(reader1 -> ComponentStateDetails.fromJson(reader1));
                    continue;
                }
                if ("policyDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyStateInner.policyDefinitionVersion = reader.getString();
                    continue;
                }
                if ("policySetDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyStateInner.policySetDefinitionVersion = reader.getString();
                    continue;
                }
                if ("policyAssignmentVersion".equals(fieldName)) {
                    deserializedPolicyStateInner.policyAssignmentVersion = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPolicyStateInner.additionalProperties = additionalProperties;
            return deserializedPolicyStateInner;
        });
    }
}

