/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.PolicyDetails;
import com.azure.resourcemanager.policyinsights.models.TrackedResourceModificationDetails;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PolicyTrackedResourceInner
implements JsonSerializable<PolicyTrackedResourceInner> {
    private String trackedResourceId;
    private PolicyDetails policyDetails;
    private TrackedResourceModificationDetails createdBy;
    private TrackedResourceModificationDetails lastModifiedBy;
    private OffsetDateTime lastUpdateUtc;

    public String trackedResourceId() {
        return this.trackedResourceId;
    }

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public TrackedResourceModificationDetails createdBy() {
        return this.createdBy;
    }

    public TrackedResourceModificationDetails lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OffsetDateTime lastUpdateUtc() {
        return this.lastUpdateUtc;
    }

    public void validate() {
        if (this.policyDetails() != null) {
            this.policyDetails().validate();
        }
        if (this.createdBy() != null) {
            this.createdBy().validate();
        }
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PolicyTrackedResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyTrackedResourceInner)jsonReader.readObject(reader -> {
            PolicyTrackedResourceInner deserializedPolicyTrackedResourceInner = new PolicyTrackedResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trackedResourceId".equals(fieldName)) {
                    deserializedPolicyTrackedResourceInner.trackedResourceId = reader.getString();
                    continue;
                }
                if ("policyDetails".equals(fieldName)) {
                    deserializedPolicyTrackedResourceInner.policyDetails = PolicyDetails.fromJson(reader);
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedPolicyTrackedResourceInner.createdBy = TrackedResourceModificationDetails.fromJson(reader);
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedPolicyTrackedResourceInner.lastModifiedBy = TrackedResourceModificationDetails.fromJson(reader);
                    continue;
                }
                if ("lastUpdateUtc".equals(fieldName)) {
                    deserializedPolicyTrackedResourceInner.lastUpdateUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyTrackedResourceInner;
        });
    }
}

