/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationProperties;
import com.azure.resourcemanager.policyinsights.models.RemediationDeploymentSummary;
import com.azure.resourcemanager.policyinsights.models.RemediationFilters;
import com.azure.resourcemanager.policyinsights.models.RemediationPropertiesFailureThreshold;
import com.azure.resourcemanager.policyinsights.models.ResourceDiscoveryMode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RemediationInner
extends ProxyResource {
    private RemediationProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private RemediationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String policyAssignmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyAssignmentId();
    }

    public RemediationInner withPolicyAssignmentId(String policyAssignmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withPolicyAssignmentId(policyAssignmentId);
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionReferenceId();
    }

    public RemediationInner withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withPolicyDefinitionReferenceId(policyDefinitionReferenceId);
        return this;
    }

    public ResourceDiscoveryMode resourceDiscoveryMode() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceDiscoveryMode();
    }

    public RemediationInner withResourceDiscoveryMode(ResourceDiscoveryMode resourceDiscoveryMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withResourceDiscoveryMode(resourceDiscoveryMode);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    public OffsetDateTime lastUpdatedOn() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdatedOn();
    }

    public RemediationFilters filters() {
        return this.innerProperties() == null ? null : this.innerProperties().filters();
    }

    public RemediationInner withFilters(RemediationFilters filters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withFilters(filters);
        return this;
    }

    public RemediationDeploymentSummary deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    public String statusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().statusMessage();
    }

    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    public Integer resourceCount() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceCount();
    }

    public RemediationInner withResourceCount(Integer resourceCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withResourceCount(resourceCount);
        return this;
    }

    public Integer parallelDeployments() {
        return this.innerProperties() == null ? null : this.innerProperties().parallelDeployments();
    }

    public RemediationInner withParallelDeployments(Integer parallelDeployments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withParallelDeployments(parallelDeployments);
        return this;
    }

    public RemediationPropertiesFailureThreshold failureThreshold() {
        return this.innerProperties() == null ? null : this.innerProperties().failureThreshold();
    }

    public RemediationInner withFailureThreshold(RemediationPropertiesFailureThreshold failureThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RemediationProperties();
        }
        this.innerProperties().withFailureThreshold(failureThreshold);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RemediationInner fromJson(JsonReader jsonReader) throws IOException {
        return (RemediationInner)((Object)jsonReader.readObject(reader -> {
            RemediationInner deserializedRemediationInner = new RemediationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRemediationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRemediationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRemediationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRemediationInner.innerProperties = RemediationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRemediationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemediationInner;
        }));
    }
}

