/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.RemediationDeploymentSummary;
import com.azure.resourcemanager.policyinsights.models.RemediationFilters;
import com.azure.resourcemanager.policyinsights.models.RemediationPropertiesFailureThreshold;
import com.azure.resourcemanager.policyinsights.models.ResourceDiscoveryMode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RemediationProperties
implements JsonSerializable<RemediationProperties> {
    private String policyAssignmentId;
    private String policyDefinitionReferenceId;
    private ResourceDiscoveryMode resourceDiscoveryMode;
    private String provisioningState;
    private OffsetDateTime createdOn;
    private OffsetDateTime lastUpdatedOn;
    private RemediationFilters filters;
    private RemediationDeploymentSummary deploymentStatus;
    private String statusMessage;
    private String correlationId;
    private Integer resourceCount;
    private Integer parallelDeployments;
    private RemediationPropertiesFailureThreshold failureThreshold;

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public RemediationProperties withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public RemediationProperties withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public ResourceDiscoveryMode resourceDiscoveryMode() {
        return this.resourceDiscoveryMode;
    }

    public RemediationProperties withResourceDiscoveryMode(ResourceDiscoveryMode resourceDiscoveryMode) {
        this.resourceDiscoveryMode = resourceDiscoveryMode;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public OffsetDateTime lastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public RemediationFilters filters() {
        return this.filters;
    }

    public RemediationProperties withFilters(RemediationFilters filters) {
        this.filters = filters;
        return this;
    }

    public RemediationDeploymentSummary deploymentStatus() {
        return this.deploymentStatus;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Integer resourceCount() {
        return this.resourceCount;
    }

    public RemediationProperties withResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
        return this;
    }

    public Integer parallelDeployments() {
        return this.parallelDeployments;
    }

    public RemediationProperties withParallelDeployments(Integer parallelDeployments) {
        this.parallelDeployments = parallelDeployments;
        return this;
    }

    public RemediationPropertiesFailureThreshold failureThreshold() {
        return this.failureThreshold;
    }

    public RemediationProperties withFailureThreshold(RemediationPropertiesFailureThreshold failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public void validate() {
        if (this.filters() != null) {
            this.filters().validate();
        }
        if (this.deploymentStatus() != null) {
            this.deploymentStatus().validate();
        }
        if (this.failureThreshold() != null) {
            this.failureThreshold().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("resourceDiscoveryMode", this.resourceDiscoveryMode == null ? null : this.resourceDiscoveryMode.toString());
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        jsonWriter.writeNumberField("resourceCount", (Number)this.resourceCount);
        jsonWriter.writeNumberField("parallelDeployments", (Number)this.parallelDeployments);
        jsonWriter.writeJsonField("failureThreshold", (JsonSerializable)this.failureThreshold);
        return jsonWriter.writeEndObject();
    }

    public static RemediationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RemediationProperties)jsonReader.readObject(reader -> {
            RemediationProperties deserializedRemediationProperties = new RemediationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedRemediationProperties.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedRemediationProperties.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("resourceDiscoveryMode".equals(fieldName)) {
                    deserializedRemediationProperties.resourceDiscoveryMode = ResourceDiscoveryMode.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRemediationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRemediationProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedOn".equals(fieldName)) {
                    deserializedRemediationProperties.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedRemediationProperties.filters = RemediationFilters.fromJson(reader);
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedRemediationProperties.deploymentStatus = RemediationDeploymentSummary.fromJson(reader);
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedRemediationProperties.statusMessage = reader.getString();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedRemediationProperties.correlationId = reader.getString();
                    continue;
                }
                if ("resourceCount".equals(fieldName)) {
                    deserializedRemediationProperties.resourceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("parallelDeployments".equals(fieldName)) {
                    deserializedRemediationProperties.parallelDeployments = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failureThreshold".equals(fieldName)) {
                    deserializedRemediationProperties.failureThreshold = RemediationPropertiesFailureThreshold.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemediationProperties;
        });
    }
}

