/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.Summary;
import java.io.IOException;
import java.util.List;

public final class SummarizeResultsInner
implements JsonSerializable<SummarizeResultsInner> {
    private String odataContext;
    private Integer odataCount;
    private List<Summary> value;

    public String odataContext() {
        return this.odataContext;
    }

    public SummarizeResultsInner withOdataContext(String odataContext) {
        this.odataContext = odataContext;
        return this;
    }

    public Integer odataCount() {
        return this.odataCount;
    }

    public SummarizeResultsInner withOdataCount(Integer odataCount) {
        this.odataCount = odataCount;
        return this;
    }

    public List<Summary> value() {
        return this.value;
    }

    public SummarizeResultsInner withValue(List<Summary> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.context", this.odataContext);
        jsonWriter.writeNumberField("@odata.count", (Number)this.odataCount);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SummarizeResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (SummarizeResultsInner)jsonReader.readObject(reader -> {
            SummarizeResultsInner deserializedSummarizeResultsInner = new SummarizeResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.context".equals(fieldName)) {
                    deserializedSummarizeResultsInner.odataContext = reader.getString();
                    continue;
                }
                if ("@odata.count".equals(fieldName)) {
                    deserializedSummarizeResultsInner.odataCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSummarizeResultsInner.value = value = reader.readArray(reader1 -> Summary.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSummarizeResultsInner;
        });
    }
}

