/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.models.AttestationInner;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.models.Attestation;
import com.azure.resourcemanager.policyinsights.models.AttestationEvidence;
import com.azure.resourcemanager.policyinsights.models.ComplianceState;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class AttestationImpl
implements Attestation,
Attestation.Definition,
Attestation.Update {
    private AttestationInner innerObject;
    private final PolicyInsightsManager serviceManager;
    private String resourceGroupName;
    private String attestationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String policyAssignmentId() {
        return this.innerModel().policyAssignmentId();
    }

    @Override
    public String policyDefinitionReferenceId() {
        return this.innerModel().policyDefinitionReferenceId();
    }

    @Override
    public ComplianceState complianceState() {
        return this.innerModel().complianceState();
    }

    @Override
    public OffsetDateTime expiresOn() {
        return this.innerModel().expiresOn();
    }

    @Override
    public String owner() {
        return this.innerModel().owner();
    }

    @Override
    public String comments() {
        return this.innerModel().comments();
    }

    @Override
    public List<AttestationEvidence> evidence() {
        List<AttestationEvidence> inner = this.innerModel().evidence();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime lastComplianceStateChangeAt() {
        return this.innerModel().lastComplianceStateChangeAt();
    }

    @Override
    public OffsetDateTime assessmentDate() {
        return this.innerModel().assessmentDate();
    }

    @Override
    public Object metadata() {
        return this.innerModel().metadata();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AttestationInner innerModel() {
        return this.innerObject;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public AttestationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Attestation create() {
        this.innerObject = this.serviceManager.serviceClient().getAttestations().createOrUpdateAtResourceGroup(this.resourceGroupName, this.attestationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Attestation create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAttestations().createOrUpdateAtResourceGroup(this.resourceGroupName, this.attestationName, this.innerModel(), context);
        return this;
    }

    AttestationImpl(String name, PolicyInsightsManager serviceManager) {
        this.innerObject = new AttestationInner();
        this.serviceManager = serviceManager;
        this.attestationName = name;
    }

    @Override
    public AttestationImpl update() {
        return this;
    }

    @Override
    public Attestation apply() {
        this.innerObject = this.serviceManager.serviceClient().getAttestations().createOrUpdateAtResourceGroup(this.resourceGroupName, this.attestationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Attestation apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAttestations().createOrUpdateAtResourceGroup(this.resourceGroupName, this.attestationName, this.innerModel(), context);
        return this;
    }

    AttestationImpl(AttestationInner innerObject, PolicyInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.attestationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "attestations");
    }

    @Override
    public Attestation refresh() {
        this.innerObject = (AttestationInner)((Object)this.serviceManager.serviceClient().getAttestations().getByResourceGroupWithResponse(this.resourceGroupName, this.attestationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Attestation refresh(Context context) {
        this.innerObject = (AttestationInner)((Object)this.serviceManager.serviceClient().getAttestations().getByResourceGroupWithResponse(this.resourceGroupName, this.attestationName, context).getValue());
        return this;
    }

    @Override
    public AttestationImpl withPolicyAssignmentId(String policyAssignmentId) {
        this.innerModel().withPolicyAssignmentId(policyAssignmentId);
        return this;
    }

    @Override
    public AttestationImpl withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.innerModel().withPolicyDefinitionReferenceId(policyDefinitionReferenceId);
        return this;
    }

    @Override
    public AttestationImpl withComplianceState(ComplianceState complianceState) {
        this.innerModel().withComplianceState(complianceState);
        return this;
    }

    @Override
    public AttestationImpl withExpiresOn(OffsetDateTime expiresOn) {
        this.innerModel().withExpiresOn(expiresOn);
        return this;
    }

    @Override
    public AttestationImpl withOwner(String owner) {
        this.innerModel().withOwner(owner);
        return this;
    }

    @Override
    public AttestationImpl withComments(String comments) {
        this.innerModel().withComments(comments);
        return this;
    }

    @Override
    public AttestationImpl withEvidence(List<AttestationEvidence> evidence) {
        this.innerModel().withEvidence(evidence);
        return this;
    }

    @Override
    public AttestationImpl withAssessmentDate(OffsetDateTime assessmentDate) {
        this.innerModel().withAssessmentDate(assessmentDate);
        return this;
    }

    @Override
    public AttestationImpl withMetadata(Object metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }
}

