/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.AttestationsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.AttestationInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.AttestationListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AttestationsClientImpl
implements AttestationsClient {
    private final AttestationsService service;
    private final PolicyInsightsClientImpl client;

    AttestationsClientImpl(PolicyInsightsClientImpl client) {
        this.service = (AttestationsService)RestProxy.create(AttestationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listSinglePageAsync(Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), top, filter, "2022-09-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listSinglePageAsync(Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), top, filter, "2022-09-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listAsync(Integer top, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listAsync() {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listAsync(Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter, context), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> list() {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listAsync(top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> list(Integer top, String filter, Context context) {
        return new PagedIterable(this.listAsync(top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String attestationName, AttestationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String attestationName, AttestationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtSubscriptionAsync(String attestationName, AttestationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtSubscriptionWithResponseAsync(attestationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtSubscriptionAsync(String attestationName, AttestationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtSubscriptionWithResponseAsync(attestationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtSubscription(String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(attestationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtSubscription(String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(attestationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtSubscriptionAsync(String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(attestationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtSubscriptionAsync(String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(attestationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtSubscription(String attestationName, AttestationInner parameters) {
        return (AttestationInner)((Object)this.createOrUpdateAtSubscriptionAsync(attestationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtSubscription(String attestationName, AttestationInner parameters, Context context) {
        return (AttestationInner)((Object)this.createOrUpdateAtSubscriptionAsync(attestationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getAtSubscriptionWithResponseAsync(String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getAtSubscriptionWithResponseAsync(String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> getAtSubscriptionAsync(String attestationName) {
        return this.getAtSubscriptionWithResponseAsync(attestationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AttestationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationInner> getAtSubscriptionWithResponse(String attestationName, Context context) {
        return (Response)this.getAtSubscriptionWithResponseAsync(attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner getAtSubscription(String attestationName) {
        return (AttestationInner)((Object)this.getAtSubscriptionWithResponse(attestationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtSubscriptionWithResponseAsync(String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtSubscriptionWithResponseAsync(String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionAsync(String attestationName) {
        return this.deleteAtSubscriptionWithResponseAsync(attestationName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAtSubscriptionWithResponse(String attestationName, Context context) {
        return (Response)this.deleteAtSubscriptionWithResponseAsync(attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtSubscription(String attestationName) {
        this.deleteAtSubscriptionWithResponse(attestationName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, top, filter, "2022-09-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, top, filter, "2022-09-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String filter) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter, context), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> listByResourceGroup(String resourceGroupName, Integer top, String filter, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName, String attestationName, AttestationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName, String attestationName, AttestationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceGroupAsync(String resourceGroupName, String attestationName, AttestationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, attestationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceGroupAsync(String resourceGroupName, String attestationName, AttestationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, attestationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceGroup(String resourceGroupName, String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceGroup(String resourceGroupName, String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName, String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName, String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtResourceGroup(String resourceGroupName, String attestationName, AttestationInner parameters) {
        return (AttestationInner)((Object)this.createOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtResourceGroup(String resourceGroupName, String attestationName, AttestationInner parameters, Context context) {
        return (AttestationInner)((Object)this.createOrUpdateAtResourceGroupAsync(resourceGroupName, attestationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> getByResourceGroupAsync(String resourceGroupName, String attestationName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, attestationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AttestationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationInner> getByResourceGroupWithResponse(String resourceGroupName, String attestationName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner getByResourceGroup(String resourceGroupName, String attestationName) {
        return (AttestationInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, attestationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String attestationName) {
        return this.deleteWithResponseAsync(resourceGroupName, attestationName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String attestationName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String attestationName) {
        this.deleteWithResponse(resourceGroupName, attestationName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceSinglePageAsync(String resourceId, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResource(this.client.getEndpoint(), resourceId, top, filter, "2022-09-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceSinglePageAsync(String resourceId, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResource(this.client.getEndpoint(), resourceId, top, filter, "2022-09-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listForResourceAsync(String resourceId, Integer top, String filter) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listForResourceAsync(String resourceId) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AttestationInner> listForResourceAsync(String resourceId, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter, context), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> listForResource(String resourceId) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listForResourceAsync(resourceId, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AttestationInner> listForResource(String resourceId, Integer top, String filter, Context context) {
        return new PagedIterable(this.listForResourceAsync(resourceId, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceWithResponseAsync(String resourceId, String attestationName, AttestationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceWithResponseAsync(String resourceId, String attestationName, AttestationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceAsync(String resourceId, String attestationName, AttestationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtResourceWithResponseAsync(resourceId, attestationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResourceAsync(String resourceId, String attestationName, AttestationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtResourceWithResponseAsync(resourceId, attestationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AttestationInner.class), (Type)((Object)AttestationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResource(String resourceId, String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtResourceAsync(resourceId, attestationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AttestationInner>, AttestationInner> beginCreateOrUpdateAtResource(String resourceId, String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtResourceAsync(resourceId, attestationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtResourceAsync(String resourceId, String attestationName, AttestationInner parameters) {
        return this.beginCreateOrUpdateAtResourceAsync(resourceId, attestationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> createOrUpdateAtResourceAsync(String resourceId, String attestationName, AttestationInner parameters, Context context) {
        return this.beginCreateOrUpdateAtResourceAsync(resourceId, attestationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtResource(String resourceId, String attestationName, AttestationInner parameters) {
        return (AttestationInner)((Object)this.createOrUpdateAtResourceAsync(resourceId, attestationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner createOrUpdateAtResource(String resourceId, String attestationName, AttestationInner parameters, Context context) {
        return (AttestationInner)((Object)this.createOrUpdateAtResourceAsync(resourceId, attestationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getAtResourceWithResponseAsync(String resourceId, String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AttestationInner>> getAtResourceWithResponseAsync(String resourceId, String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AttestationInner> getAtResourceAsync(String resourceId, String attestationName) {
        return this.getAtResourceWithResponseAsync(resourceId, attestationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AttestationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationInner> getAtResourceWithResponse(String resourceId, String attestationName, Context context) {
        return (Response)this.getAtResourceWithResponseAsync(resourceId, attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationInner getAtResource(String resourceId, String attestationName) {
        return (AttestationInner)((Object)this.getAtResourceWithResponse(resourceId, attestationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtResourceWithResponseAsync(String resourceId, String attestationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtResourceWithResponseAsync(String resourceId, String attestationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (attestationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationName is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtResource(this.client.getEndpoint(), resourceId, attestationName, "2022-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtResourceAsync(String resourceId, String attestationName) {
        return this.deleteAtResourceWithResponseAsync(resourceId, attestationName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAtResourceWithResponse(String resourceId, String attestationName, Context context) {
        return (Response)this.deleteAtResourceWithResponseAsync(resourceId, attestationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtResource(String resourceId, String attestationName) {
        this.deleteAtResourceWithResponse(resourceId, attestationName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForSubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AttestationInner>> listForResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AttestationListResult)res.getValue()).value(), ((AttestationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface AttestationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") AttestationInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationInner>> getAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/attestations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$filter") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="attestationName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AttestationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="attestationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="attestationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.PolicyInsights/attestations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> listForResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") AttestationInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationInner>> getAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="attestationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> listForSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> listForResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AttestationListResult>> listForResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

