/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.ComponentPolicyStatesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.ComponentPolicyStatesQueryResultsInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.ComponentPolicyStatesResource;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class ComponentPolicyStatesClientImpl
implements ComponentPolicyStatesClient {
    private final ComponentPolicyStatesService service;
    private final PolicyInsightsClientImpl client;

    ComponentPolicyStatesClientImpl(PolicyInsightsClientImpl client) {
        this.service = (ComponentPolicyStatesService)RestProxy.create(ComponentPolicyStatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscriptionWithResponseAsync(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscription(this.client.getEndpoint(), subscriptionId, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscriptionWithResponseAsync(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscription(this.client.getEndpoint(), subscriptionId, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForSubscriptionAsync(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return this.listQueryResultsForSubscriptionWithResponseAsync(subscriptionId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForSubscriptionWithResponse(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        return (Response)this.listQueryResultsForSubscriptionWithResponseAsync(subscriptionId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForSubscription(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForSubscriptionWithResponse(subscriptionId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroupWithResponseAsync(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), subscriptionId, resourceGroupName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroupWithResponseAsync(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), subscriptionId, resourceGroupName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceGroupAsync(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return this.listQueryResultsForResourceGroupWithResponseAsync(subscriptionId, resourceGroupName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceGroupWithResponse(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        return (Response)this.listQueryResultsForResourceGroupWithResponseAsync(subscriptionId, resourceGroupName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForResourceGroup(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForResourceGroupWithResponse(subscriptionId, resourceGroupName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceWithResponseAsync(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResource(this.client.getEndpoint(), resourceId, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, expand, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceWithResponseAsync(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResource(this.client.getEndpoint(), resourceId, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, expand, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceAsync(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        return this.listQueryResultsForResourceWithResponseAsync(resourceId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, expand).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceWithResponse(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, Context context) {
        return (Response)this.listQueryResultsForResourceWithResponseAsync(resourceId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForResource(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForResourceWithResponse(resourceId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, expand, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForPolicyDefinitionWithResponseAsync(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), subscriptionId, "Microsoft.Authorization", policyDefinitionName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForPolicyDefinitionWithResponseAsync(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), subscriptionId, "Microsoft.Authorization", policyDefinitionName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForPolicyDefinitionAsync(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return this.listQueryResultsForPolicyDefinitionWithResponseAsync(subscriptionId, policyDefinitionName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForPolicyDefinitionWithResponse(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        return (Response)this.listQueryResultsForPolicyDefinitionWithResponseAsync(subscriptionId, policyDefinitionName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForPolicyDefinition(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForPolicyDefinitionWithResponse(subscriptionId, policyDefinitionName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponseAsync(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), subscriptionId, "Microsoft.Authorization", policyAssignmentName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponseAsync(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), subscriptionId, "Microsoft.Authorization", policyAssignmentName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return this.listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponseAsync(subscriptionId, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponse(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        return (Response)this.listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponseAsync(subscriptionId, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForSubscriptionLevelPolicyAssignment(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponse(subscriptionId, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponseAsync(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponseAsync(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (componentPolicyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPolicyStatesResource is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2022-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, componentPolicyStatesResource, "2022-04-01", top, orderBy, select, from, to, filter, apply, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return this.listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponseAsync(subscriptionId, resourceGroupName, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply).flatMap(res -> Mono.justOrEmpty((Object)((ComponentPolicyStatesQueryResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentPolicyStatesQueryResultsInner> listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponse(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        return (Response)this.listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponseAsync(subscriptionId, resourceGroupName, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentPolicyStatesQueryResultsInner listQueryResultsForResourceGroupLevelPolicyAssignment(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        return (ComponentPolicyStatesQueryResultsInner)this.listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponse(subscriptionId, resourceGroupName, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface ComponentPolicyStatesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @QueryParam(value="$apply") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @QueryParam(value="$expand") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForPolicyDefinition(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="authorizationNamespace") String var3, @PathParam(value="policyDefinitionName") String var4, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForSubscriptionLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="authorizationNamespace") String var3, @PathParam(value="policyAssignmentName") String var4, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/componentPolicyStates/{componentPolicyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentPolicyStatesQueryResultsInner>> listQueryResultsForResourceGroupLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyAssignmentName") String var5, @PathParam(value="componentPolicyStatesResource") ComponentPolicyStatesResource var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$top") Integer var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="$select") String var10, @QueryParam(value="$from") OffsetDateTime var11, @QueryParam(value="$to") OffsetDateTime var12, @QueryParam(value="$filter") String var13, @QueryParam(value="$apply") String var14, @HeaderParam(value="Accept") String var15, Context var16);
    }
}

