/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.ComponentPolicyStatesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.ComponentPolicyStatesQueryResultsInner;
import com.azure.resourcemanager.policyinsights.implementation.ComponentPolicyStatesQueryResultsImpl;
import com.azure.resourcemanager.policyinsights.models.ComponentPolicyStates;
import com.azure.resourcemanager.policyinsights.models.ComponentPolicyStatesQueryResults;
import com.azure.resourcemanager.policyinsights.models.ComponentPolicyStatesResource;
import java.time.OffsetDateTime;

public final class ComponentPolicyStatesImpl
implements ComponentPolicyStates {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentPolicyStatesImpl.class);
    private final ComponentPolicyStatesClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public ComponentPolicyStatesImpl(ComponentPolicyStatesClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForSubscriptionWithResponse(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForSubscriptionWithResponse(subscriptionId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForSubscription(String subscriptionId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForSubscription(subscriptionId, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForResourceGroupWithResponse(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForResourceGroupWithResponse(subscriptionId, resourceGroupName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForResourceGroup(String subscriptionId, String resourceGroupName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForResourceGroup(subscriptionId, resourceGroupName, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForResourceWithResponse(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForResourceWithResponse(resourceId, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForResource(String resourceId, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForResource(resourceId, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForPolicyDefinitionWithResponse(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForPolicyDefinitionWithResponse(subscriptionId, policyDefinitionName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForPolicyDefinition(String subscriptionId, String policyDefinitionName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForPolicyDefinition(subscriptionId, policyDefinitionName, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponse(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignmentWithResponse(subscriptionId, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForSubscriptionLevelPolicyAssignment(String subscriptionId, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignment(subscriptionId, policyAssignmentName, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPolicyStatesQueryResults> listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponse(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, Context context) {
        Response<ComponentPolicyStatesQueryResultsInner> inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignmentWithResponse(subscriptionId, resourceGroupName, policyAssignmentName, componentPolicyStatesResource, top, orderBy, select, from, to, filter, apply, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPolicyStatesQueryResultsImpl((ComponentPolicyStatesQueryResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPolicyStatesQueryResults listQueryResultsForResourceGroupLevelPolicyAssignment(String subscriptionId, String resourceGroupName, String policyAssignmentName, ComponentPolicyStatesResource componentPolicyStatesResource) {
        ComponentPolicyStatesQueryResultsInner inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignment(subscriptionId, resourceGroupName, policyAssignmentName, componentPolicyStatesResource);
        if (inner != null) {
            return new ComponentPolicyStatesQueryResultsImpl(inner, this.manager());
        }
        return null;
    }

    private ComponentPolicyStatesClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

