/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.OperationsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.OperationsListResultsInner;
import com.azure.resourcemanager.policyinsights.implementation.OperationsListResultsImpl;
import com.azure.resourcemanager.policyinsights.models.Operations;
import com.azure.resourcemanager.policyinsights.models.OperationsListResults;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationsListResults> listWithResponse(Context context) {
        Response<OperationsListResultsInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationsListResultsImpl((OperationsListResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationsListResults list() {
        OperationsListResultsInner inner = this.serviceClient().list();
        if (inner != null) {
            return new OperationsListResultsImpl(inner, this.manager());
        }
        return null;
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

