/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.PolicyEventsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyEventInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyEventsQueryResults;
import com.azure.resourcemanager.policyinsights.models.PolicyEventsResourceType;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class PolicyEventsClientImpl
implements PolicyEventsClient {
    private final PolicyEventsService service;
    private final PolicyInsightsClientImpl client;

    PolicyEventsClientImpl(PolicyInsightsClientImpl client) {
        this.service = (PolicyEventsService)RestProxy.create(PolicyEventsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForManagementGroupSinglePageAsync(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), policyEventsResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForManagementGroupSinglePageAsync(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), policyEventsResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForManagementGroupAsync(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForManagementGroupAsync(PolicyEventsResourceType policyEventsResource, String managementGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForManagementGroupAsync(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForManagementGroup(PolicyEventsResourceType policyEventsResource, String managementGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForManagementGroup(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyEventsResource, subscriptionId, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyEventsResource, subscriptionId, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForSubscription(PolicyEventsResourceType policyEventsResource, String subscriptionId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForSubscription(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceGroupSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), policyEventsResource, subscriptionId, resourceGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceGroupSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), policyEventsResource, subscriptionId, resourceGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResourceGroup(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResourceGroup(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceSinglePageAsync(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResource(this.client.getEndpoint(), policyEventsResource, resourceId, "2019-10-01", top, orderBy, select, from, to, filter, apply, expand, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceSinglePageAsync(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResource(this.client.getEndpoint(), policyEventsResource, resourceId, "2019-10-01", top, orderBy, select, from, to, filter, apply, expand, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceAsync(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceAsync(PolicyEventsResourceType policyEventsResource, String resourceId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceAsync(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResource(PolicyEventsResourceType policyEventsResource, String resourceId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceAsync(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResource(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceAsync(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForPolicySetDefinitionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForPolicySetDefinition(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForPolicySetDefinitionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForPolicySetDefinition(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicySetDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicySetDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicySetDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForPolicySetDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForPolicySetDefinitionAsync(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForPolicySetDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForPolicySetDefinitionAsync(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForPolicyDefinitionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForPolicyDefinitionSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicyDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicyDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForPolicyDefinitionAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForPolicyDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForPolicyDefinitionAsync(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForPolicyDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForPolicyDefinitionAsync(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyEventsResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyEventsResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyEventsResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyEventsResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyEventsResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyEventInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyEventInner> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> nextLinkSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.nextLink(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyEventInner>> nextLinkSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.nextLink(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyEventsQueryResults)res.getValue()).value(), ((PolicyEventsQueryResults)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface PolicyEventsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="managementGroupsNamespace") String var3, @PathParam(value="managementGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @QueryParam(value="$apply") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForSubscription(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @QueryParam(value="$skiptoken") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @QueryParam(value="$apply") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForResource(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="resourceId", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @QueryParam(value="$expand") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForPolicySetDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policySetDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForPolicyDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForSubscriptionLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyAssignmentName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> listQueryResultsForResourceGroupLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyEventsResource") PolicyEventsResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="authorizationNamespace") String var5, @PathParam(value="policyAssignmentName") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$top") Integer var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="$select") String var10, @QueryParam(value="$from") OffsetDateTime var11, @QueryParam(value="$to") OffsetDateTime var12, @QueryParam(value="$filter") String var13, @QueryParam(value="$apply") String var14, @QueryParam(value="$skiptoken") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyEventsQueryResults>> nextLink(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

