/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.PolicyEventsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyEventInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyEventImpl;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.models.PolicyEvent;
import com.azure.resourcemanager.policyinsights.models.PolicyEvents;
import com.azure.resourcemanager.policyinsights.models.PolicyEventsResourceType;
import java.time.OffsetDateTime;

public final class PolicyEventsImpl
implements PolicyEvents {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyEventsImpl.class);
    private final PolicyEventsClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public PolicyEventsImpl(PolicyEventsClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForManagementGroup(PolicyEventsResourceType policyEventsResource, String managementGroupName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForManagementGroup(policyEventsResource, managementGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForManagementGroup(PolicyEventsResourceType policyEventsResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForManagementGroup(policyEventsResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForSubscription(PolicyEventsResourceType policyEventsResource, String subscriptionId) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForSubscription(policyEventsResource, subscriptionId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForSubscription(PolicyEventsResourceType policyEventsResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForSubscription(policyEventsResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResourceGroup(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResourceGroup(policyEventsResource, subscriptionId, resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResourceGroup(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResourceGroup(policyEventsResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResource(PolicyEventsResourceType policyEventsResource, String resourceId) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResource(policyEventsResource, resourceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResource(PolicyEventsResourceType policyEventsResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResource(policyEventsResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForPolicySetDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForPolicySetDefinition(policyEventsResource, subscriptionId, policySetDefinitionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForPolicySetDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForPolicySetDefinition(policyEventsResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForPolicyDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForPolicyDefinition(policyEventsResource, subscriptionId, policyDefinitionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForPolicyDefinition(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForPolicyDefinition(policyEventsResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignment(policyEventsResource, subscriptionId, policyAssignmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignment(policyEventsResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignment(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyEvent> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyEventsResourceType policyEventsResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyEventInner> inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignment(policyEventsResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyEventImpl((PolicyEventInner)inner1, this.manager()));
    }

    private PolicyEventsClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

