/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.PolicyMetadatasClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyMetadataInner;
import com.azure.resourcemanager.policyinsights.fluent.models.SlimPolicyMetadataInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyMetadataCollection;
import reactor.core.publisher.Mono;

public final class PolicyMetadatasClientImpl
implements PolicyMetadatasClient {
    private final PolicyMetadatasService service;
    private final PolicyInsightsClientImpl client;

    PolicyMetadatasClientImpl(PolicyInsightsClientImpl client) {
        this.service = (PolicyMetadatasService)RestProxy.create(PolicyMetadatasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyMetadataInner>> getResourceWithResponseAsync(String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResource(this.client.getEndpoint(), resourceName, "2019-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyMetadataInner>> getResourceWithResponseAsync(String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getResource(this.client.getEndpoint(), resourceName, "2019-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PolicyMetadataInner> getResourceAsync(String resourceName) {
        return this.getResourceWithResponseAsync(resourceName).flatMap(res -> Mono.justOrEmpty((Object)((PolicyMetadataInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyMetadataInner> getResourceWithResponse(String resourceName, Context context) {
        return (Response)this.getResourceWithResponseAsync(resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyMetadataInner getResource(String resourceName) {
        return (PolicyMetadataInner)this.getResourceWithResponse(resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SlimPolicyMetadataInner>> listSinglePageAsync(Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-10-01", top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyMetadataCollection)res.getValue()).value(), ((PolicyMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SlimPolicyMetadataInner>> listSinglePageAsync(Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-10-01", top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyMetadataCollection)res.getValue()).value(), ((PolicyMetadataCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SlimPolicyMetadataInner> listAsync(Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SlimPolicyMetadataInner> listAsync() {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SlimPolicyMetadataInner> listAsync(Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SlimPolicyMetadataInner> list() {
        Integer top = null;
        return new PagedIterable(this.listAsync(top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SlimPolicyMetadataInner> list(Integer top, Context context) {
        return new PagedIterable(this.listAsync(top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SlimPolicyMetadataInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyMetadataCollection)res.getValue()).value(), ((PolicyMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SlimPolicyMetadataInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyMetadataCollection)res.getValue()).value(), ((PolicyMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface PolicyMetadatasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.PolicyInsights/policyMetadata/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyMetadataInner>> getResource(@HostParam(value="$host") String var1, @PathParam(value="resourceName", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.PolicyInsights/policyMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyMetadataCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$top") Integer var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyMetadataCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

