/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.PolicyMetadatasClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyMetadataInner;
import com.azure.resourcemanager.policyinsights.fluent.models.SlimPolicyMetadataInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyMetadataImpl;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.implementation.SlimPolicyMetadataImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyMetadata;
import com.azure.resourcemanager.policyinsights.models.PolicyMetadatas;
import com.azure.resourcemanager.policyinsights.models.SlimPolicyMetadata;

public final class PolicyMetadatasImpl
implements PolicyMetadatas {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyMetadatasImpl.class);
    private final PolicyMetadatasClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public PolicyMetadatasImpl(PolicyMetadatasClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PolicyMetadata> getResourceWithResponse(String resourceName, Context context) {
        Response<PolicyMetadataInner> inner = this.serviceClient().getResourceWithResponse(resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyMetadataImpl((PolicyMetadataInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyMetadata getResource(String resourceName) {
        PolicyMetadataInner inner = this.serviceClient().getResource(resourceName);
        if (inner != null) {
            return new PolicyMetadataImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SlimPolicyMetadata> list() {
        PagedIterable<SlimPolicyMetadataInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SlimPolicyMetadataImpl((SlimPolicyMetadataInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SlimPolicyMetadata> list(Integer top, Context context) {
        PagedIterable<SlimPolicyMetadataInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SlimPolicyMetadataImpl((SlimPolicyMetadataInner)inner1, this.manager()));
    }

    private PolicyMetadatasClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

