/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.PolicyRestrictionsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.CheckRestrictionsResultInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.CheckManagementGroupRestrictionsRequest;
import com.azure.resourcemanager.policyinsights.models.CheckRestrictionsRequest;
import reactor.core.publisher.Mono;

public final class PolicyRestrictionsClientImpl
implements PolicyRestrictionsClient {
    private final PolicyRestrictionsService service;
    private final PolicyInsightsClientImpl client;

    PolicyRestrictionsClientImpl(PolicyInsightsClientImpl client) {
        this.service = (PolicyRestrictionsService)RestProxy.create(PolicyRestrictionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtSubscriptionScopeWithResponseAsync(CheckRestrictionsRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkAtSubscriptionScope(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtSubscriptionScopeWithResponseAsync(CheckRestrictionsRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkAtSubscriptionScope(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-03-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckRestrictionsResultInner> checkAtSubscriptionScopeAsync(CheckRestrictionsRequest parameters) {
        return this.checkAtSubscriptionScopeWithResponseAsync(parameters).flatMap(res -> Mono.justOrEmpty((Object)((CheckRestrictionsResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckRestrictionsResultInner> checkAtSubscriptionScopeWithResponse(CheckRestrictionsRequest parameters, Context context) {
        return (Response)this.checkAtSubscriptionScopeWithResponseAsync(parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckRestrictionsResultInner checkAtSubscriptionScope(CheckRestrictionsRequest parameters) {
        return (CheckRestrictionsResultInner)this.checkAtSubscriptionScopeWithResponse(parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtResourceGroupScopeWithResponseAsync(String resourceGroupName, CheckRestrictionsRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkAtResourceGroupScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2022-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtResourceGroupScopeWithResponseAsync(String resourceGroupName, CheckRestrictionsRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkAtResourceGroupScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2022-03-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckRestrictionsResultInner> checkAtResourceGroupScopeAsync(String resourceGroupName, CheckRestrictionsRequest parameters) {
        return this.checkAtResourceGroupScopeWithResponseAsync(resourceGroupName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CheckRestrictionsResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckRestrictionsResultInner> checkAtResourceGroupScopeWithResponse(String resourceGroupName, CheckRestrictionsRequest parameters, Context context) {
        return (Response)this.checkAtResourceGroupScopeWithResponseAsync(resourceGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckRestrictionsResultInner checkAtResourceGroupScope(String resourceGroupName, CheckRestrictionsRequest parameters) {
        return (CheckRestrictionsResultInner)this.checkAtResourceGroupScopeWithResponse(resourceGroupName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtManagementGroupScopeWithResponseAsync(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkAtManagementGroupScope(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, "2022-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckRestrictionsResultInner>> checkAtManagementGroupScopeWithResponseAsync(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2022-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkAtManagementGroupScope(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, "2022-03-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckRestrictionsResultInner> checkAtManagementGroupScopeAsync(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters) {
        return this.checkAtManagementGroupScopeWithResponseAsync(managementGroupId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CheckRestrictionsResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckRestrictionsResultInner> checkAtManagementGroupScopeWithResponse(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters, Context context) {
        return (Response)this.checkAtManagementGroupScopeWithResponseAsync(managementGroupId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckRestrictionsResultInner checkAtManagementGroupScope(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters) {
        return (CheckRestrictionsResultInner)this.checkAtManagementGroupScopeWithResponse(managementGroupId, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface PolicyRestrictionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckRestrictionsResultInner>> checkAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckRestrictionsRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckRestrictionsResultInner>> checkAtResourceGroupScope(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CheckRestrictionsRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckRestrictionsResultInner>> checkAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CheckManagementGroupRestrictionsRequest var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

