/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.PolicyRestrictionsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.CheckRestrictionsResultInner;
import com.azure.resourcemanager.policyinsights.implementation.CheckRestrictionsResultImpl;
import com.azure.resourcemanager.policyinsights.models.CheckManagementGroupRestrictionsRequest;
import com.azure.resourcemanager.policyinsights.models.CheckRestrictionsRequest;
import com.azure.resourcemanager.policyinsights.models.CheckRestrictionsResult;
import com.azure.resourcemanager.policyinsights.models.PolicyRestrictions;

public final class PolicyRestrictionsImpl
implements PolicyRestrictions {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyRestrictionsImpl.class);
    private final PolicyRestrictionsClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public PolicyRestrictionsImpl(PolicyRestrictionsClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckRestrictionsResult> checkAtSubscriptionScopeWithResponse(CheckRestrictionsRequest parameters, Context context) {
        Response<CheckRestrictionsResultInner> inner = this.serviceClient().checkAtSubscriptionScopeWithResponse(parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckRestrictionsResultImpl((CheckRestrictionsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckRestrictionsResult checkAtSubscriptionScope(CheckRestrictionsRequest parameters) {
        CheckRestrictionsResultInner inner = this.serviceClient().checkAtSubscriptionScope(parameters);
        if (inner != null) {
            return new CheckRestrictionsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CheckRestrictionsResult> checkAtResourceGroupScopeWithResponse(String resourceGroupName, CheckRestrictionsRequest parameters, Context context) {
        Response<CheckRestrictionsResultInner> inner = this.serviceClient().checkAtResourceGroupScopeWithResponse(resourceGroupName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckRestrictionsResultImpl((CheckRestrictionsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckRestrictionsResult checkAtResourceGroupScope(String resourceGroupName, CheckRestrictionsRequest parameters) {
        CheckRestrictionsResultInner inner = this.serviceClient().checkAtResourceGroupScope(resourceGroupName, parameters);
        if (inner != null) {
            return new CheckRestrictionsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CheckRestrictionsResult> checkAtManagementGroupScopeWithResponse(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters, Context context) {
        Response<CheckRestrictionsResultInner> inner = this.serviceClient().checkAtManagementGroupScopeWithResponse(managementGroupId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckRestrictionsResultImpl((CheckRestrictionsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckRestrictionsResult checkAtManagementGroupScope(String managementGroupId, CheckManagementGroupRestrictionsRequest parameters) {
        CheckRestrictionsResultInner inner = this.serviceClient().checkAtManagementGroupScope(managementGroupId, parameters);
        if (inner != null) {
            return new CheckRestrictionsResultImpl(inner, this.manager());
        }
        return null;
    }

    private PolicyRestrictionsClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

