/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.PolicyStatesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyStateInner;
import com.azure.resourcemanager.policyinsights.fluent.models.SummarizeResultsInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyStatesQueryResults;
import com.azure.resourcemanager.policyinsights.models.PolicyStatesResource;
import com.azure.resourcemanager.policyinsights.models.PolicyStatesSummaryResourceType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PolicyStatesClientImpl
implements PolicyStatesClient {
    private final PolicyStatesService service;
    private final PolicyInsightsClientImpl client;

    PolicyStatesClientImpl(PolicyInsightsClientImpl client) {
        this.service = (PolicyStatesService)RestProxy.create(PolicyStatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForManagementGroupSinglePageAsync(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), policyStatesResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForManagementGroupSinglePageAsync(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), policyStatesResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForManagementGroupAsync(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForManagementGroupAsync(PolicyStatesResource policyStatesResource, String managementGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForManagementGroupAsync(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForManagementGroup(PolicyStatesResource policyStatesResource, String managementGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForManagementGroup(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForManagementGroupWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForManagementGroup(this.client.getEndpoint(), policyStatesSummaryResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForManagementGroupWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForManagementGroup(this.client.getEndpoint(), policyStatesSummaryResource, "Microsoft.Management", managementGroupName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForManagementGroupAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForManagementGroupWithResponseAsync(policyStatesSummaryResource, managementGroupName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForManagementGroupWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForManagementGroupWithResponseAsync(policyStatesSummaryResource, managementGroupName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForManagementGroup(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForManagementGroupWithResponse(policyStatesSummaryResource, managementGroupName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyStatesResource, subscriptionId, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyStatesResource, subscriptionId, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionAsync(PolicyStatesResource policyStatesResource, String subscriptionId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForSubscription(PolicyStatesResource policyStatesResource, String subscriptionId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForSubscription(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForSubscriptionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForSubscription(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForSubscriptionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForSubscription(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForSubscriptionAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForSubscriptionWithResponseAsync(policyStatesSummaryResource, subscriptionId, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForSubscriptionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForSubscriptionWithResponseAsync(policyStatesSummaryResource, subscriptionId, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForSubscription(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForSubscriptionWithResponse(policyStatesSummaryResource, subscriptionId, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceGroupSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), policyStatesResource, subscriptionId, resourceGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceGroupSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), policyStatesResource, subscriptionId, resourceGroupName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResourceGroup(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResourceGroup(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceGroupWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForResourceGroup(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, resourceGroupName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceGroupWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForResourceGroup(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, resourceGroupName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForResourceGroupAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForResourceGroupWithResponseAsync(policyStatesSummaryResource, subscriptionId, resourceGroupName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForResourceGroupWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForResourceGroupWithResponseAsync(policyStatesSummaryResource, subscriptionId, resourceGroupName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForResourceGroup(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForResourceGroupWithResponse(policyStatesSummaryResource, subscriptionId, resourceGroupName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceSinglePageAsync(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResource(this.client.getEndpoint(), policyStatesResource, resourceId, "2019-10-01", top, orderBy, select, from, to, filter, apply, expand, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceSinglePageAsync(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResource(this.client.getEndpoint(), policyStatesResource, resourceId, "2019-10-01", top, orderBy, select, from, to, filter, apply, expand, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceAsync(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceAsync(PolicyStatesResource policyStatesResource, String resourceId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceAsync(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResource(PolicyStatesResource policyStatesResource, String resourceId) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String expand = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceAsync(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResource(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceAsync(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForResource(this.client.getEndpoint(), policyStatesSummaryResource, resourceId, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForResource(this.client.getEndpoint(), policyStatesSummaryResource, resourceId, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForResourceAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForResourceWithResponseAsync(policyStatesSummaryResource, resourceId, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForResourceWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForResourceWithResponseAsync(policyStatesSummaryResource, resourceId, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForResource(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForResourceWithResponse(policyStatesSummaryResource, resourceId, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> triggerSubscriptionEvaluationWithResponseAsync(String subscriptionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.triggerSubscriptionEvaluation(this.client.getEndpoint(), subscriptionId, "2019-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> triggerSubscriptionEvaluationWithResponseAsync(String subscriptionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.triggerSubscriptionEvaluation(this.client.getEndpoint(), subscriptionId, "2019-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginTriggerSubscriptionEvaluationAsync(String subscriptionId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.triggerSubscriptionEvaluationWithResponseAsync(subscriptionId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginTriggerSubscriptionEvaluationAsync(String subscriptionId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.triggerSubscriptionEvaluationWithResponseAsync(subscriptionId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTriggerSubscriptionEvaluation(String subscriptionId) {
        return this.beginTriggerSubscriptionEvaluationAsync(subscriptionId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTriggerSubscriptionEvaluation(String subscriptionId, Context context) {
        return this.beginTriggerSubscriptionEvaluationAsync(subscriptionId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> triggerSubscriptionEvaluationAsync(String subscriptionId) {
        return this.beginTriggerSubscriptionEvaluationAsync(subscriptionId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> triggerSubscriptionEvaluationAsync(String subscriptionId, Context context) {
        return this.beginTriggerSubscriptionEvaluationAsync(subscriptionId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void triggerSubscriptionEvaluation(String subscriptionId) {
        this.triggerSubscriptionEvaluationAsync(subscriptionId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void triggerSubscriptionEvaluation(String subscriptionId, Context context) {
        this.triggerSubscriptionEvaluationAsync(subscriptionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> triggerResourceGroupEvaluationWithResponseAsync(String subscriptionId, String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.triggerResourceGroupEvaluation(this.client.getEndpoint(), subscriptionId, resourceGroupName, "2019-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> triggerResourceGroupEvaluationWithResponseAsync(String subscriptionId, String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.triggerResourceGroupEvaluation(this.client.getEndpoint(), subscriptionId, resourceGroupName, "2019-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginTriggerResourceGroupEvaluationAsync(String subscriptionId, String resourceGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.triggerResourceGroupEvaluationWithResponseAsync(subscriptionId, resourceGroupName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginTriggerResourceGroupEvaluationAsync(String subscriptionId, String resourceGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.triggerResourceGroupEvaluationWithResponseAsync(subscriptionId, resourceGroupName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTriggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName) {
        return this.beginTriggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTriggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName, Context context) {
        return this.beginTriggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> triggerResourceGroupEvaluationAsync(String subscriptionId, String resourceGroupName) {
        return this.beginTriggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> triggerResourceGroupEvaluationAsync(String subscriptionId, String resourceGroupName, Context context) {
        return this.beginTriggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void triggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName) {
        this.triggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void triggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName, Context context) {
        this.triggerResourceGroupEvaluationAsync(subscriptionId, resourceGroupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForPolicySetDefinitionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForPolicySetDefinition(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForPolicySetDefinitionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForPolicySetDefinition(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicySetDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicySetDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicySetDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForPolicySetDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForPolicySetDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForPolicySetDefinitionAsync(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForPolicySetDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForPolicySetDefinitionAsync(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForPolicySetDefinitionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForPolicySetDefinition(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForPolicySetDefinitionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForPolicySetDefinition(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policySetDefinitionName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForPolicySetDefinitionAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForPolicySetDefinitionWithResponseAsync(policyStatesSummaryResource, subscriptionId, policySetDefinitionName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForPolicySetDefinitionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForPolicySetDefinitionWithResponseAsync(policyStatesSummaryResource, subscriptionId, policySetDefinitionName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForPolicySetDefinition(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForPolicySetDefinitionWithResponse(policyStatesSummaryResource, subscriptionId, policySetDefinitionName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForPolicyDefinitionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForPolicyDefinitionSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForPolicyDefinition(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicyDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicyDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForPolicyDefinitionAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForPolicyDefinitionSinglePageAsync(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForPolicyDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForPolicyDefinitionAsync(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForPolicyDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForPolicyDefinitionAsync(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForPolicyDefinitionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForPolicyDefinition(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForPolicyDefinitionWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForPolicyDefinition(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policyDefinitionName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForPolicyDefinitionAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForPolicyDefinitionWithResponseAsync(policyStatesSummaryResource, subscriptionId, policyDefinitionName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForPolicyDefinitionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForPolicyDefinitionWithResponseAsync(policyStatesSummaryResource, subscriptionId, policyDefinitionName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForPolicyDefinition(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForPolicyDefinitionWithResponse(policyStatesSummaryResource, subscriptionId, policyDefinitionName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyStatesResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForSubscriptionLevelPolicyAssignmentAsync(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForSubscriptionLevelPolicyAssignmentWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForSubscriptionLevelPolicyAssignmentWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForSubscriptionLevelPolicyAssignment(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForSubscriptionLevelPolicyAssignmentAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForSubscriptionLevelPolicyAssignmentWithResponseAsync(policyStatesSummaryResource, subscriptionId, policyAssignmentName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForSubscriptionLevelPolicyAssignmentWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForSubscriptionLevelPolicyAssignmentWithResponseAsync(policyStatesSummaryResource, subscriptionId, policyAssignmentName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForSubscriptionLevelPolicyAssignment(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForSubscriptionLevelPolicyAssignmentWithResponse(policyStatesSummaryResource, subscriptionId, policyAssignmentName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyStatesResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyStatesResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, orderBy, select, from, to, filter, apply, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken), nextLink -> this.nextLinkSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyStateInner> listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupLevelPolicyAssignmentSinglePageAsync(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context), nextLink -> this.nextLinkSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        String orderBy = null;
        String select = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        String apply = null;
        String skipToken = null;
        return new PagedIterable(this.listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyStateInner> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceGroupLevelPolicyAssignmentAsync(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceGroupLevelPolicyAssignmentWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.summarizeForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, from, to, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SummarizeResultsInner>> summarizeForResourceGroupLevelPolicyAssignmentWithResponseAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyStatesSummaryResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyStatesSummaryResource is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        String authorizationNamespace = "Microsoft.Authorization";
        String apiVersion = "2019-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.summarizeForResourceGroupLevelPolicyAssignment(this.client.getEndpoint(), policyStatesSummaryResource, subscriptionId, resourceGroupName, "Microsoft.Authorization", policyAssignmentName, "2019-10-01", top, from, to, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SummarizeResultsInner> summarizeForResourceGroupLevelPolicyAssignmentAsync(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return this.summarizeForResourceGroupLevelPolicyAssignmentWithResponseAsync(policyStatesSummaryResource, subscriptionId, resourceGroupName, policyAssignmentName, top, from, to, filter).flatMap(res -> Mono.justOrEmpty((Object)((SummarizeResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SummarizeResultsInner> summarizeForResourceGroupLevelPolicyAssignmentWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        return (Response)this.summarizeForResourceGroupLevelPolicyAssignmentWithResponseAsync(policyStatesSummaryResource, subscriptionId, resourceGroupName, policyAssignmentName, top, from, to, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SummarizeResultsInner summarizeForResourceGroupLevelPolicyAssignment(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        Integer top = null;
        OffsetDateTime from = null;
        OffsetDateTime to = null;
        String filter = null;
        return (SummarizeResultsInner)this.summarizeForResourceGroupLevelPolicyAssignmentWithResponse(policyStatesSummaryResource, subscriptionId, resourceGroupName, policyAssignmentName, top, from, to, filter, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> nextLinkSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.nextLink(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyStateInner>> nextLinkSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.nextLink(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyStatesQueryResults)res.getValue()).value(), ((PolicyStatesQueryResults)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface PolicyStatesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="managementGroupsNamespace") String var3, @PathParam(value="managementGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @QueryParam(value="$apply") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="managementGroupsNamespace") String var3, @PathParam(value="managementGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$from") OffsetDateTime var7, @QueryParam(value="$to") OffsetDateTime var8, @QueryParam(value="$filter") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForSubscription(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @QueryParam(value="$skiptoken") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForSubscription(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$from") OffsetDateTime var6, @QueryParam(value="$to") OffsetDateTime var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @QueryParam(value="$apply") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$from") OffsetDateTime var7, @QueryParam(value="$to") OffsetDateTime var8, @QueryParam(value="$filter") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForResource(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="resourceId", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$orderby") String var6, @QueryParam(value="$select") String var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @QueryParam(value="$apply") String var11, @QueryParam(value="$expand") String var12, @QueryParam(value="$skiptoken") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForResource(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="resourceId", encoded=true) String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$from") OffsetDateTime var6, @QueryParam(value="$to") OffsetDateTime var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> triggerSubscriptionEvaluation(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> triggerResourceGroupEvaluation(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForPolicySetDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policySetDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForPolicySetDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policySetDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForPolicyDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForPolicyDefinition(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyDefinitionName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForSubscriptionLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyAssignmentName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$from") OffsetDateTime var10, @QueryParam(value="$to") OffsetDateTime var11, @QueryParam(value="$filter") String var12, @QueryParam(value="$apply") String var13, @QueryParam(value="$skiptoken") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForSubscriptionLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="authorizationNamespace") String var4, @PathParam(value="policyAssignmentName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$from") OffsetDateTime var8, @QueryParam(value="$to") OffsetDateTime var9, @QueryParam(value="$filter") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> listQueryResultsForResourceGroupLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyStatesResource") PolicyStatesResource var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="authorizationNamespace") String var5, @PathParam(value="policyAssignmentName") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$top") Integer var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="$select") String var10, @QueryParam(value="$from") OffsetDateTime var11, @QueryParam(value="$to") OffsetDateTime var12, @QueryParam(value="$filter") String var13, @QueryParam(value="$apply") String var14, @QueryParam(value="$skiptoken") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SummarizeResultsInner>> summarizeForResourceGroupLevelPolicyAssignment(@HostParam(value="$host") String var1, @PathParam(value="policyStatesSummaryResource") PolicyStatesSummaryResourceType var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="authorizationNamespace") String var5, @PathParam(value="policyAssignmentName") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$top") Integer var8, @QueryParam(value="$from") OffsetDateTime var9, @QueryParam(value="$to") OffsetDateTime var10, @QueryParam(value="$filter") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyStatesQueryResults>> nextLink(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

