/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.PolicyStatesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyStateInner;
import com.azure.resourcemanager.policyinsights.fluent.models.SummarizeResultsInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyStateImpl;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.implementation.SummarizeResultsImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyState;
import com.azure.resourcemanager.policyinsights.models.PolicyStates;
import com.azure.resourcemanager.policyinsights.models.PolicyStatesResource;
import com.azure.resourcemanager.policyinsights.models.PolicyStatesSummaryResourceType;
import com.azure.resourcemanager.policyinsights.models.SummarizeResults;
import java.time.OffsetDateTime;

public final class PolicyStatesImpl
implements PolicyStates {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyStatesImpl.class);
    private final PolicyStatesClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public PolicyStatesImpl(PolicyStatesClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForManagementGroup(PolicyStatesResource policyStatesResource, String managementGroupName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForManagementGroup(policyStatesResource, managementGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForManagementGroup(PolicyStatesResource policyStatesResource, String managementGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForManagementGroup(policyStatesResource, managementGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForManagementGroupWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForManagementGroupWithResponse(policyStatesSummaryResource, managementGroupName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForManagementGroup(PolicyStatesSummaryResourceType policyStatesSummaryResource, String managementGroupName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForManagementGroup(policyStatesSummaryResource, managementGroupName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForSubscription(PolicyStatesResource policyStatesResource, String subscriptionId) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForSubscription(policyStatesResource, subscriptionId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForSubscription(PolicyStatesResource policyStatesResource, String subscriptionId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForSubscription(policyStatesResource, subscriptionId, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForSubscriptionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForSubscriptionWithResponse(policyStatesSummaryResource, subscriptionId, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForSubscription(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForSubscription(policyStatesSummaryResource, subscriptionId);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResourceGroup(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResourceGroup(policyStatesResource, subscriptionId, resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResourceGroup(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResourceGroup(policyStatesResource, subscriptionId, resourceGroupName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForResourceGroupWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForResourceGroupWithResponse(policyStatesSummaryResource, subscriptionId, resourceGroupName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForResourceGroup(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForResourceGroup(policyStatesSummaryResource, subscriptionId, resourceGroupName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResource(PolicyStatesResource policyStatesResource, String resourceId) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResource(policyStatesResource, resourceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResource(PolicyStatesResource policyStatesResource, String resourceId, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String expand, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResource(policyStatesResource, resourceId, top, orderBy, select, from, to, filter, apply, expand, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForResourceWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForResourceWithResponse(policyStatesSummaryResource, resourceId, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForResource(PolicyStatesSummaryResourceType policyStatesSummaryResource, String resourceId) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForResource(policyStatesSummaryResource, resourceId);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void triggerSubscriptionEvaluation(String subscriptionId) {
        this.serviceClient().triggerSubscriptionEvaluation(subscriptionId);
    }

    @Override
    public void triggerSubscriptionEvaluation(String subscriptionId, Context context) {
        this.serviceClient().triggerSubscriptionEvaluation(subscriptionId, context);
    }

    @Override
    public void triggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName) {
        this.serviceClient().triggerResourceGroupEvaluation(subscriptionId, resourceGroupName);
    }

    @Override
    public void triggerResourceGroupEvaluation(String subscriptionId, String resourceGroupName, Context context) {
        this.serviceClient().triggerResourceGroupEvaluation(subscriptionId, resourceGroupName, context);
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForPolicySetDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForPolicySetDefinition(policyStatesResource, subscriptionId, policySetDefinitionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForPolicySetDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policySetDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForPolicySetDefinition(policyStatesResource, subscriptionId, policySetDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForPolicySetDefinitionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForPolicySetDefinitionWithResponse(policyStatesSummaryResource, subscriptionId, policySetDefinitionName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForPolicySetDefinition(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policySetDefinitionName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForPolicySetDefinition(policyStatesSummaryResource, subscriptionId, policySetDefinitionName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForPolicyDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForPolicyDefinition(policyStatesResource, subscriptionId, policyDefinitionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForPolicyDefinition(PolicyStatesResource policyStatesResource, String subscriptionId, String policyDefinitionName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForPolicyDefinition(policyStatesResource, subscriptionId, policyDefinitionName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForPolicyDefinitionWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForPolicyDefinitionWithResponse(policyStatesSummaryResource, subscriptionId, policyDefinitionName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForPolicyDefinition(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyDefinitionName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForPolicyDefinition(policyStatesSummaryResource, subscriptionId, policyDefinitionName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignment(policyStatesResource, subscriptionId, policyAssignmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForSubscriptionLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForSubscriptionLevelPolicyAssignment(policyStatesResource, subscriptionId, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForSubscriptionLevelPolicyAssignmentWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForSubscriptionLevelPolicyAssignmentWithResponse(policyStatesSummaryResource, subscriptionId, policyAssignmentName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForSubscriptionLevelPolicyAssignment(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String policyAssignmentName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForSubscriptionLevelPolicyAssignment(policyStatesSummaryResource, subscriptionId, policyAssignmentName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignment(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyState> listQueryResultsForResourceGroupLevelPolicyAssignment(PolicyStatesResource policyStatesResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, String orderBy, String select, OffsetDateTime from, OffsetDateTime to, String filter, String apply, String skipToken, Context context) {
        PagedIterable<PolicyStateInner> inner = this.serviceClient().listQueryResultsForResourceGroupLevelPolicyAssignment(policyStatesResource, subscriptionId, resourceGroupName, policyAssignmentName, top, orderBy, select, from, to, filter, apply, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyStateImpl((PolicyStateInner)inner1, this.manager()));
    }

    @Override
    public Response<SummarizeResults> summarizeForResourceGroupLevelPolicyAssignmentWithResponse(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName, Integer top, OffsetDateTime from, OffsetDateTime to, String filter, Context context) {
        Response<SummarizeResultsInner> inner = this.serviceClient().summarizeForResourceGroupLevelPolicyAssignmentWithResponse(policyStatesSummaryResource, subscriptionId, resourceGroupName, policyAssignmentName, top, from, to, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummarizeResultsImpl((SummarizeResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SummarizeResults summarizeForResourceGroupLevelPolicyAssignment(PolicyStatesSummaryResourceType policyStatesSummaryResource, String subscriptionId, String resourceGroupName, String policyAssignmentName) {
        SummarizeResultsInner inner = this.serviceClient().summarizeForResourceGroupLevelPolicyAssignment(policyStatesSummaryResource, subscriptionId, resourceGroupName, policyAssignmentName);
        if (inner != null) {
            return new SummarizeResultsImpl(inner, this.manager());
        }
        return null;
    }

    private PolicyStatesClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

