/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.PolicyTrackedResourcesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyTrackedResourceInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.PolicyTrackedResourcesQueryResults;
import com.azure.resourcemanager.policyinsights.models.PolicyTrackedResourcesResourceType;
import reactor.core.publisher.Mono;

public final class PolicyTrackedResourcesClientImpl
implements PolicyTrackedResourcesClient {
    private final PolicyTrackedResourcesService service;
    private final PolicyInsightsClientImpl client;

    PolicyTrackedResourcesClientImpl(PolicyInsightsClientImpl client) {
        this.service = (PolicyTrackedResourcesService)RestProxy.create(PolicyTrackedResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForManagementGroupSinglePageAsync(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupName, policyTrackedResourcesResource, top, filter, "2018-07-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForManagementGroupSinglePageAsync(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupName, policyTrackedResourcesResource, top, filter, "2018-07-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForManagementGroupAsync(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(managementGroupName, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForManagementGroupAsync(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(managementGroupName, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForManagementGroupAsync(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForManagementGroupSinglePageAsync(managementGroupName, policyTrackedResourcesResource, top, filter, context), nextLink -> this.listQueryResultsForManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForManagementGroup(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(managementGroupName, policyTrackedResourcesResource, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForManagementGroup(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedIterable(this.listQueryResultsForManagementGroupAsync(managementGroupName, policyTrackedResourcesResource, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyTrackedResourcesResource, top, filter, this.client.getSubscriptionId(), "2018-07-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForSubscriptionSinglePageAsync(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscription(this.client.getEndpoint(), policyTrackedResourcesResource, top, filter, this.client.getSubscriptionId(), "2018-07-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForSubscriptionAsync(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForSubscriptionAsync(PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForSubscriptionAsync(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForSubscriptionSinglePageAsync(policyTrackedResourcesResource, top, filter, context), nextLink -> this.listQueryResultsForSubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForSubscription(PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyTrackedResourcesResource, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForSubscription(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedIterable(this.listQueryResultsForSubscriptionAsync(policyTrackedResourcesResource, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceGroupSinglePageAsync(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), resourceGroupName, policyTrackedResourcesResource, top, filter, this.client.getSubscriptionId(), "2018-07-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceGroupSinglePageAsync(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroup(this.client.getEndpoint(), resourceGroupName, policyTrackedResourcesResource, top, filter, this.client.getSubscriptionId(), "2018-07-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceGroupAsync(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(resourceGroupName, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceGroupAsync(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(resourceGroupName, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceGroupAsync(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceGroupSinglePageAsync(resourceGroupName, policyTrackedResourcesResource, top, filter, context), nextLink -> this.listQueryResultsForResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForResourceGroup(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(resourceGroupName, policyTrackedResourcesResource, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForResourceGroup(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceGroupAsync(resourceGroupName, policyTrackedResourcesResource, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceSinglePageAsync(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResource(this.client.getEndpoint(), resourceId, policyTrackedResourcesResource, top, filter, "2018-07-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceSinglePageAsync(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (policyTrackedResourcesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyTrackedResourcesResource is required and cannot be null."));
        }
        String apiVersion = "2018-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResource(this.client.getEndpoint(), resourceId, policyTrackedResourcesResource, top, filter, "2018-07-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceAsync(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(resourceId, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceAsync(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(resourceId, policyTrackedResourcesResource, top, filter), nextLink -> this.listQueryResultsForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyTrackedResourceInner> listQueryResultsForResourceAsync(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listQueryResultsForResourceSinglePageAsync(resourceId, policyTrackedResourcesResource, top, filter, context), nextLink -> this.listQueryResultsForResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForResource(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listQueryResultsForResourceAsync(resourceId, policyTrackedResourcesResource, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyTrackedResourceInner> listQueryResultsForResource(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        return new PagedIterable(this.listQueryResultsForResourceAsync(resourceId, policyTrackedResourcesResource, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForSubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listQueryResultsForResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyTrackedResourceInner>> listQueryResultsForResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listQueryResultsForResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyTrackedResourcesQueryResults)res.getValue()).value(), ((PolicyTrackedResourcesQueryResults)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface PolicyTrackedResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupName") String var3, @PathParam(value="policyTrackedResourcesResource") PolicyTrackedResourcesResourceType var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$filter") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForSubscription(@HostParam(value="$host") String var1, @PathParam(value="policyTrackedResourcesResource") PolicyTrackedResourcesResourceType var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$filter") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="policyTrackedResourcesResource") PolicyTrackedResourcesResourceType var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="policyTrackedResourcesResource") PolicyTrackedResourcesResourceType var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$filter") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyTrackedResourcesQueryResults>> listQueryResultsForResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

