/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.PolicyTrackedResourcesClient;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyTrackedResourceInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyTrackedResourceImpl;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.models.PolicyTrackedResource;
import com.azure.resourcemanager.policyinsights.models.PolicyTrackedResources;
import com.azure.resourcemanager.policyinsights.models.PolicyTrackedResourcesResourceType;

public final class PolicyTrackedResourcesImpl
implements PolicyTrackedResources {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyTrackedResourcesImpl.class);
    private final PolicyTrackedResourcesClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public PolicyTrackedResourcesImpl(PolicyTrackedResourcesClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForManagementGroup(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForManagementGroup(managementGroupName, policyTrackedResourcesResource);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForManagementGroup(String managementGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForManagementGroup(managementGroupName, policyTrackedResourcesResource, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForSubscription(PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForSubscription(policyTrackedResourcesResource);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForSubscription(PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForSubscription(policyTrackedResourcesResource, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForResourceGroup(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForResourceGroup(resourceGroupName, policyTrackedResourcesResource);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForResourceGroup(String resourceGroupName, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForResourceGroup(resourceGroupName, policyTrackedResourcesResource, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForResource(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForResource(resourceId, policyTrackedResourcesResource);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PolicyTrackedResource> listQueryResultsForResource(String resourceId, PolicyTrackedResourcesResourceType policyTrackedResourcesResource, Integer top, String filter, Context context) {
        PagedIterable<PolicyTrackedResourceInner> inner = this.serviceClient().listQueryResultsForResource(resourceId, policyTrackedResourcesResource, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyTrackedResourceImpl((PolicyTrackedResourceInner)inner1, this.manager()));
    }

    private PolicyTrackedResourcesClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }
}

