/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationInner;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.models.Remediation;
import com.azure.resourcemanager.policyinsights.models.RemediationDeployment;
import com.azure.resourcemanager.policyinsights.models.RemediationDeploymentSummary;
import com.azure.resourcemanager.policyinsights.models.RemediationFilters;
import com.azure.resourcemanager.policyinsights.models.RemediationPropertiesFailureThreshold;
import com.azure.resourcemanager.policyinsights.models.ResourceDiscoveryMode;
import java.time.OffsetDateTime;

public final class RemediationImpl
implements Remediation,
Remediation.Definition,
Remediation.Update {
    private RemediationInner innerObject;
    private final PolicyInsightsManager serviceManager;
    private String resourceGroupName;
    private String remediationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String policyAssignmentId() {
        return this.innerModel().policyAssignmentId();
    }

    @Override
    public String policyDefinitionReferenceId() {
        return this.innerModel().policyDefinitionReferenceId();
    }

    @Override
    public ResourceDiscoveryMode resourceDiscoveryMode() {
        return this.innerModel().resourceDiscoveryMode();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime createdOn() {
        return this.innerModel().createdOn();
    }

    @Override
    public OffsetDateTime lastUpdatedOn() {
        return this.innerModel().lastUpdatedOn();
    }

    @Override
    public RemediationFilters filters() {
        return this.innerModel().filters();
    }

    @Override
    public RemediationDeploymentSummary deploymentStatus() {
        return this.innerModel().deploymentStatus();
    }

    @Override
    public String statusMessage() {
        return this.innerModel().statusMessage();
    }

    @Override
    public String correlationId() {
        return this.innerModel().correlationId();
    }

    @Override
    public Integer resourceCount() {
        return this.innerModel().resourceCount();
    }

    @Override
    public Integer parallelDeployments() {
        return this.innerModel().parallelDeployments();
    }

    @Override
    public RemediationPropertiesFailureThreshold failureThreshold() {
        return this.innerModel().failureThreshold();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public RemediationInner innerModel() {
        return this.innerObject;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public RemediationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Remediation create() {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().createOrUpdateAtResourceGroupWithResponse(this.resourceGroupName, this.remediationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Remediation create(Context context) {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().createOrUpdateAtResourceGroupWithResponse(this.resourceGroupName, this.remediationName, this.innerModel(), context).getValue());
        return this;
    }

    RemediationImpl(String name, PolicyInsightsManager serviceManager) {
        this.innerObject = new RemediationInner();
        this.serviceManager = serviceManager;
        this.remediationName = name;
    }

    @Override
    public RemediationImpl update() {
        return this;
    }

    @Override
    public Remediation apply() {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().createOrUpdateAtResourceGroupWithResponse(this.resourceGroupName, this.remediationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Remediation apply(Context context) {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().createOrUpdateAtResourceGroupWithResponse(this.resourceGroupName, this.remediationName, this.innerModel(), context).getValue());
        return this;
    }

    RemediationImpl(RemediationInner innerObject, PolicyInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.remediationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "remediations");
    }

    @Override
    public Remediation refresh() {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().getByResourceGroupWithResponse(this.resourceGroupName, this.remediationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Remediation refresh(Context context) {
        this.innerObject = (RemediationInner)((Object)this.serviceManager.serviceClient().getRemediations().getByResourceGroupWithResponse(this.resourceGroupName, this.remediationName, context).getValue());
        return this;
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup() {
        return this.serviceManager.remediations().listDeploymentsAtResourceGroup(this.resourceGroupName, this.remediationName);
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup(Integer top, Context context) {
        return this.serviceManager.remediations().listDeploymentsAtResourceGroup(this.resourceGroupName, this.remediationName, top, context);
    }

    @Override
    public Response<Remediation> cancelAtResourceGroupWithResponse(Context context) {
        return this.serviceManager.remediations().cancelAtResourceGroupWithResponse(this.resourceGroupName, this.remediationName, context);
    }

    @Override
    public Remediation cancelAtResourceGroup() {
        return this.serviceManager.remediations().cancelAtResourceGroup(this.resourceGroupName, this.remediationName);
    }

    @Override
    public RemediationImpl withPolicyAssignmentId(String policyAssignmentId) {
        this.innerModel().withPolicyAssignmentId(policyAssignmentId);
        return this;
    }

    @Override
    public RemediationImpl withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.innerModel().withPolicyDefinitionReferenceId(policyDefinitionReferenceId);
        return this;
    }

    @Override
    public RemediationImpl withResourceDiscoveryMode(ResourceDiscoveryMode resourceDiscoveryMode) {
        this.innerModel().withResourceDiscoveryMode(resourceDiscoveryMode);
        return this;
    }

    @Override
    public RemediationImpl withFilters(RemediationFilters filters) {
        this.innerModel().withFilters(filters);
        return this;
    }

    @Override
    public RemediationImpl withResourceCount(Integer resourceCount) {
        this.innerModel().withResourceCount(resourceCount);
        return this;
    }

    @Override
    public RemediationImpl withParallelDeployments(Integer parallelDeployments) {
        this.innerModel().withParallelDeployments(parallelDeployments);
        return this;
    }

    @Override
    public RemediationImpl withFailureThreshold(RemediationPropertiesFailureThreshold failureThreshold) {
        this.innerModel().withFailureThreshold(failureThreshold);
        return this;
    }
}

