/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.policyinsights.fluent.RemediationsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationDeploymentInner;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationInner;
import com.azure.resourcemanager.policyinsights.implementation.PolicyInsightsClientImpl;
import com.azure.resourcemanager.policyinsights.models.RemediationDeploymentsListResult;
import com.azure.resourcemanager.policyinsights.models.RemediationListResult;
import reactor.core.publisher.Mono;

public final class RemediationsClientImpl
implements RemediationsClient {
    private final RemediationsService service;
    private final PolicyInsightsClientImpl client;

    RemediationsClientImpl(PolicyInsightsClientImpl client) {
        this.service = (RemediationsService)RestProxy.create(RemediationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtManagementGroupSinglePageAsync(String managementGroupId, String remediationName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, top, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtManagementGroupSinglePageAsync(String managementGroupId, String remediationName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, top, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtManagementGroupAsync(String managementGroupId, String remediationName, Integer top) {
        return new PagedFlux(() -> this.listDeploymentsAtManagementGroupSinglePageAsync(managementGroupId, remediationName, top), nextLink -> this.listDeploymentsAtManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtManagementGroupAsync(String managementGroupId, String remediationName) {
        Integer top = null;
        return new PagedFlux(() -> this.listDeploymentsAtManagementGroupSinglePageAsync(managementGroupId, remediationName, top), nextLink -> this.listDeploymentsAtManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtManagementGroupAsync(String managementGroupId, String remediationName, Integer top, Context context) {
        return new PagedFlux(() -> this.listDeploymentsAtManagementGroupSinglePageAsync(managementGroupId, remediationName, top, context), nextLink -> this.listDeploymentsAtManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtManagementGroup(String managementGroupId, String remediationName) {
        Integer top = null;
        return new PagedIterable(this.listDeploymentsAtManagementGroupAsync(managementGroupId, remediationName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtManagementGroup(String managementGroupId, String remediationName, Integer top, Context context) {
        return new PagedIterable(this.listDeploymentsAtManagementGroupAsync(managementGroupId, remediationName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> cancelAtManagementGroupAsync(String managementGroupId, String remediationName) {
        return this.cancelAtManagementGroupWithResponseAsync(managementGroupId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> cancelAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        return (Response)this.cancelAtManagementGroupWithResponseAsync(managementGroupId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner cancelAtManagementGroup(String managementGroupId, String remediationName) {
        return (RemediationInner)((Object)this.cancelAtManagementGroupWithResponse(managementGroupId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForManagementGroupSinglePageAsync(String managementGroupId, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, top, filter, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForManagementGroupSinglePageAsync(String managementGroupId, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, top, filter, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForManagementGroupAsync(String managementGroupId, Integer top, String filter) {
        return new PagedFlux(() -> this.listForManagementGroupSinglePageAsync(managementGroupId, top, filter), nextLink -> this.listForManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForManagementGroupAsync(String managementGroupId) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listForManagementGroupSinglePageAsync(managementGroupId, top, filter), nextLink -> this.listForManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForManagementGroupAsync(String managementGroupId, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listForManagementGroupSinglePageAsync(managementGroupId, top, filter, context), nextLink -> this.listForManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listForManagementGroup(String managementGroupId) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listForManagementGroupAsync(managementGroupId, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listForManagementGroup(String managementGroupId, Integer top, String filter, Context context) {
        return new PagedIterable(this.listForManagementGroupAsync(managementGroupId, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName, RemediationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName, RemediationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> createOrUpdateAtManagementGroupAsync(String managementGroupId, String remediationName, RemediationInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, remediationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> createOrUpdateAtManagementGroupWithResponse(String managementGroupId, String remediationName, RemediationInner parameters, Context context) {
        return (Response)this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, remediationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner createOrUpdateAtManagementGroup(String managementGroupId, String remediationName, RemediationInner parameters) {
        return (RemediationInner)((Object)this.createOrUpdateAtManagementGroupWithResponse(managementGroupId, remediationName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> getAtManagementGroupAsync(String managementGroupId, String remediationName) {
        return this.getAtManagementGroupWithResponseAsync(managementGroupId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> getAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        return (Response)this.getAtManagementGroupWithResponseAsync(managementGroupId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner getAtManagementGroup(String managementGroupId, String remediationName) {
        return (RemediationInner)((Object)this.getAtManagementGroupWithResponse(managementGroupId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtManagementGroupWithResponseAsync(String managementGroupId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String managementGroupsNamespace = "Microsoft.Management";
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), "Microsoft.Management", managementGroupId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> deleteAtManagementGroupAsync(String managementGroupId, String remediationName) {
        return this.deleteAtManagementGroupWithResponseAsync(managementGroupId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> deleteAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        return (Response)this.deleteAtManagementGroupWithResponseAsync(managementGroupId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner deleteAtManagementGroup(String managementGroupId, String remediationName) {
        return (RemediationInner)((Object)this.deleteAtManagementGroupWithResponse(managementGroupId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtSubscriptionSinglePageAsync(String remediationName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, top, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtSubscriptionSinglePageAsync(String remediationName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, top, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtSubscriptionAsync(String remediationName, Integer top) {
        return new PagedFlux(() -> this.listDeploymentsAtSubscriptionSinglePageAsync(remediationName, top), nextLink -> this.listDeploymentsAtSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtSubscriptionAsync(String remediationName) {
        Integer top = null;
        return new PagedFlux(() -> this.listDeploymentsAtSubscriptionSinglePageAsync(remediationName, top), nextLink -> this.listDeploymentsAtSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtSubscriptionAsync(String remediationName, Integer top, Context context) {
        return new PagedFlux(() -> this.listDeploymentsAtSubscriptionSinglePageAsync(remediationName, top, context), nextLink -> this.listDeploymentsAtSubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtSubscription(String remediationName) {
        Integer top = null;
        return new PagedIterable(this.listDeploymentsAtSubscriptionAsync(remediationName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtSubscription(String remediationName, Integer top, Context context) {
        return new PagedIterable(this.listDeploymentsAtSubscriptionAsync(remediationName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtSubscriptionWithResponseAsync(String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtSubscriptionWithResponseAsync(String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> cancelAtSubscriptionAsync(String remediationName) {
        return this.cancelAtSubscriptionWithResponseAsync(remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> cancelAtSubscriptionWithResponse(String remediationName, Context context) {
        return (Response)this.cancelAtSubscriptionWithResponseAsync(remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner cancelAtSubscription(String remediationName) {
        return (RemediationInner)((Object)this.cancelAtSubscriptionWithResponse(remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listSinglePageAsync(Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), top, filter, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listSinglePageAsync(Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), top, filter, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listAsync(Integer top, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listAsync() {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listAsync(Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, filter, context), nextLink -> this.listForSubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> list() {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listAsync(top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> list(Integer top, String filter, Context context) {
        return new PagedIterable(this.listAsync(top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtSubscriptionWithResponseAsync(String remediationName, RemediationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtSubscriptionWithResponseAsync(String remediationName, RemediationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> createOrUpdateAtSubscriptionAsync(String remediationName, RemediationInner parameters) {
        return this.createOrUpdateAtSubscriptionWithResponseAsync(remediationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> createOrUpdateAtSubscriptionWithResponse(String remediationName, RemediationInner parameters, Context context) {
        return (Response)this.createOrUpdateAtSubscriptionWithResponseAsync(remediationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner createOrUpdateAtSubscription(String remediationName, RemediationInner parameters) {
        return (RemediationInner)((Object)this.createOrUpdateAtSubscriptionWithResponse(remediationName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtSubscriptionWithResponseAsync(String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtSubscriptionWithResponseAsync(String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> getAtSubscriptionAsync(String remediationName) {
        return this.getAtSubscriptionWithResponseAsync(remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> getAtSubscriptionWithResponse(String remediationName, Context context) {
        return (Response)this.getAtSubscriptionWithResponseAsync(remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner getAtSubscription(String remediationName) {
        return (RemediationInner)((Object)this.getAtSubscriptionWithResponse(remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtSubscriptionWithResponseAsync(String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtSubscriptionWithResponseAsync(String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> deleteAtSubscriptionAsync(String remediationName) {
        return this.deleteAtSubscriptionWithResponseAsync(remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> deleteAtSubscriptionWithResponse(String remediationName, Context context) {
        return (Response)this.deleteAtSubscriptionWithResponseAsync(remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner deleteAtSubscription(String remediationName) {
        return (RemediationInner)((Object)this.deleteAtSubscriptionWithResponse(remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceGroupSinglePageAsync(String resourceGroupName, String remediationName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, top, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceGroupSinglePageAsync(String resourceGroupName, String remediationName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, top, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceGroupAsync(String resourceGroupName, String remediationName, Integer top) {
        return new PagedFlux(() -> this.listDeploymentsAtResourceGroupSinglePageAsync(resourceGroupName, remediationName, top), nextLink -> this.listDeploymentsAtResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceGroupAsync(String resourceGroupName, String remediationName) {
        Integer top = null;
        return new PagedFlux(() -> this.listDeploymentsAtResourceGroupSinglePageAsync(resourceGroupName, remediationName, top), nextLink -> this.listDeploymentsAtResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceGroupAsync(String resourceGroupName, String remediationName, Integer top, Context context) {
        return new PagedFlux(() -> this.listDeploymentsAtResourceGroupSinglePageAsync(resourceGroupName, remediationName, top, context), nextLink -> this.listDeploymentsAtResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtResourceGroup(String resourceGroupName, String remediationName) {
        Integer top = null;
        return new PagedIterable(this.listDeploymentsAtResourceGroupAsync(resourceGroupName, remediationName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtResourceGroup(String resourceGroupName, String remediationName, Integer top, Context context) {
        return new PagedIterable(this.listDeploymentsAtResourceGroupAsync(resourceGroupName, remediationName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtResourceGroupWithResponseAsync(String resourceGroupName, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtResourceGroupWithResponseAsync(String resourceGroupName, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> cancelAtResourceGroupAsync(String resourceGroupName, String remediationName) {
        return this.cancelAtResourceGroupWithResponseAsync(resourceGroupName, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> cancelAtResourceGroupWithResponse(String resourceGroupName, String remediationName, Context context) {
        return (Response)this.cancelAtResourceGroupWithResponseAsync(resourceGroupName, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner cancelAtResourceGroup(String resourceGroupName, String remediationName) {
        return (RemediationInner)((Object)this.cancelAtResourceGroupWithResponse(resourceGroupName, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, top, filter, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, top, filter, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String filter) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, filter, context), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listByResourceGroup(String resourceGroupName, Integer top, String filter, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName, String remediationName, RemediationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName, String remediationName, RemediationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName, String remediationName, RemediationInner parameters) {
        return this.createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, remediationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> createOrUpdateAtResourceGroupWithResponse(String resourceGroupName, String remediationName, RemediationInner parameters, Context context) {
        return (Response)this.createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, remediationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner createOrUpdateAtResourceGroup(String resourceGroupName, String remediationName, RemediationInner parameters) {
        return (RemediationInner)((Object)this.createOrUpdateAtResourceGroupWithResponse(resourceGroupName, remediationName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> getByResourceGroupAsync(String resourceGroupName, String remediationName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> getByResourceGroupWithResponse(String resourceGroupName, String remediationName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner getByResourceGroup(String resourceGroupName, String remediationName) {
        return (RemediationInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteWithResponseAsync(String resourceGroupName, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteWithResponseAsync(String resourceGroupName, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> deleteAsync(String resourceGroupName, String remediationName) {
        return this.deleteWithResponseAsync(resourceGroupName, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> deleteWithResponse(String resourceGroupName, String remediationName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner delete(String resourceGroupName, String remediationName) {
        return (RemediationInner)((Object)this.deleteWithResponse(resourceGroupName, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceSinglePageAsync(String resourceId, String remediationName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtResource(this.client.getEndpoint(), resourceId, remediationName, top, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceSinglePageAsync(String resourceId, String remediationName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtResource(this.client.getEndpoint(), resourceId, remediationName, top, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceAsync(String resourceId, String remediationName, Integer top) {
        return new PagedFlux(() -> this.listDeploymentsAtResourceSinglePageAsync(resourceId, remediationName, top), nextLink -> this.listDeploymentsAtResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceAsync(String resourceId, String remediationName) {
        Integer top = null;
        return new PagedFlux(() -> this.listDeploymentsAtResourceSinglePageAsync(resourceId, remediationName, top), nextLink -> this.listDeploymentsAtResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationDeploymentInner> listDeploymentsAtResourceAsync(String resourceId, String remediationName, Integer top, Context context) {
        return new PagedFlux(() -> this.listDeploymentsAtResourceSinglePageAsync(resourceId, remediationName, top, context), nextLink -> this.listDeploymentsAtResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtResource(String resourceId, String remediationName) {
        Integer top = null;
        return new PagedIterable(this.listDeploymentsAtResourceAsync(resourceId, remediationName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationDeploymentInner> listDeploymentsAtResource(String resourceId, String remediationName, Integer top, Context context) {
        return new PagedIterable(this.listDeploymentsAtResourceAsync(resourceId, remediationName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtResourceWithResponseAsync(String resourceId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> cancelAtResourceWithResponseAsync(String resourceId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> cancelAtResourceAsync(String resourceId, String remediationName) {
        return this.cancelAtResourceWithResponseAsync(resourceId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> cancelAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        return (Response)this.cancelAtResourceWithResponseAsync(resourceId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner cancelAtResource(String resourceId, String remediationName) {
        return (RemediationInner)((Object)this.cancelAtResourceWithResponse(resourceId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceSinglePageAsync(String resourceId, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResource(this.client.getEndpoint(), resourceId, top, filter, "2021-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceSinglePageAsync(String resourceId, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResource(this.client.getEndpoint(), resourceId, top, filter, "2021-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForResourceAsync(String resourceId, Integer top, String filter) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForResourceAsync(String resourceId) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemediationInner> listForResourceAsync(String resourceId, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceId, top, filter, context), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listForResource(String resourceId) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listForResourceAsync(resourceId, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemediationInner> listForResource(String resourceId, Integer top, String filter, Context context) {
        return new PagedIterable(this.listForResourceAsync(resourceId, top, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtResourceWithResponseAsync(String resourceId, String remediationName, RemediationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> createOrUpdateAtResourceWithResponseAsync(String resourceId, String remediationName, RemediationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> createOrUpdateAtResourceAsync(String resourceId, String remediationName, RemediationInner parameters) {
        return this.createOrUpdateAtResourceWithResponseAsync(resourceId, remediationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> createOrUpdateAtResourceWithResponse(String resourceId, String remediationName, RemediationInner parameters, Context context) {
        return (Response)this.createOrUpdateAtResourceWithResponseAsync(resourceId, remediationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner createOrUpdateAtResource(String resourceId, String remediationName, RemediationInner parameters) {
        return (RemediationInner)((Object)this.createOrUpdateAtResourceWithResponse(resourceId, remediationName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtResourceWithResponseAsync(String resourceId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> getAtResourceWithResponseAsync(String resourceId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> getAtResourceAsync(String resourceId, String remediationName) {
        return this.getAtResourceWithResponseAsync(resourceId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> getAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        return (Response)this.getAtResourceWithResponseAsync(resourceId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner getAtResource(String resourceId, String remediationName) {
        return (RemediationInner)((Object)this.getAtResourceWithResponse(resourceId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtResourceWithResponseAsync(String resourceId, String remediationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemediationInner>> deleteAtResourceWithResponseAsync(String resourceId, String remediationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (remediationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter remediationName is required and cannot be null."));
        }
        String apiVersion = "2021-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtResource(this.client.getEndpoint(), resourceId, remediationName, "2021-10-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemediationInner> deleteAtResourceAsync(String resourceId, String remediationName) {
        return this.deleteAtResourceWithResponseAsync(resourceId, remediationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RemediationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemediationInner> deleteAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        return (Response)this.deleteAtResourceWithResponseAsync(resourceId, remediationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemediationInner deleteAtResource(String resourceId, String remediationName) {
        return (RemediationInner)((Object)this.deleteAtResourceWithResponse(resourceId, remediationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtSubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForSubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentsAtResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationDeploymentInner>> listDeploymentsAtResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentsAtResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationDeploymentsListResult)res.getValue()).value(), ((RemediationDeploymentsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemediationInner>> listForResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RemediationListResult)res.getValue()).value(), ((RemediationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyInsightsClient")
    public static interface RemediationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> cancelAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$filter") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RemediationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupsNamespace") String var2, @PathParam(value="managementGroupId") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> cancelAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> createOrUpdateAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RemediationInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> getAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> deleteAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> cancelAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$filter") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> createOrUpdateAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RemediationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="remediationName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> cancelAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> createOrUpdateAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RemediationInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> getAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationInner>> deleteAtResource(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @PathParam(value="remediationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationDeploymentsListResult>> listDeploymentsAtResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemediationListResult>> listForResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

