/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.policyinsights.PolicyInsightsManager;
import com.azure.resourcemanager.policyinsights.fluent.RemediationsClient;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationDeploymentInner;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationInner;
import com.azure.resourcemanager.policyinsights.implementation.RemediationDeploymentImpl;
import com.azure.resourcemanager.policyinsights.implementation.RemediationImpl;
import com.azure.resourcemanager.policyinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.policyinsights.models.Remediation;
import com.azure.resourcemanager.policyinsights.models.RemediationDeployment;
import com.azure.resourcemanager.policyinsights.models.Remediations;

public final class RemediationsImpl
implements Remediations {
    private static final ClientLogger LOGGER = new ClientLogger(RemediationsImpl.class);
    private final RemediationsClient innerClient;
    private final PolicyInsightsManager serviceManager;

    public RemediationsImpl(RemediationsClient innerClient, PolicyInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtManagementGroup(String managementGroupId, String remediationName) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtManagementGroup(managementGroupId, remediationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtManagementGroup(String managementGroupId, String remediationName, Integer top, Context context) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtManagementGroup(managementGroupId, remediationName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public Response<Remediation> cancelAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().cancelAtManagementGroupWithResponse(managementGroupId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation cancelAtManagementGroup(String managementGroupId, String remediationName) {
        RemediationInner inner = this.serviceClient().cancelAtManagementGroup(managementGroupId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Remediation> listForManagementGroup(String managementGroupId) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listForManagementGroup(managementGroupId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Remediation> listForManagementGroup(String managementGroupId, Integer top, String filter, Context context) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listForManagementGroup(managementGroupId, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Remediation> createOrUpdateAtManagementGroupWithResponse(String managementGroupId, String remediationName, RemediationInner parameters, Context context) {
        Response<RemediationInner> inner = this.serviceClient().createOrUpdateAtManagementGroupWithResponse(managementGroupId, remediationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation createOrUpdateAtManagementGroup(String managementGroupId, String remediationName, RemediationInner parameters) {
        RemediationInner inner = this.serviceClient().createOrUpdateAtManagementGroup(managementGroupId, remediationName, parameters);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> getAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().getAtManagementGroupWithResponse(managementGroupId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation getAtManagementGroup(String managementGroupId, String remediationName) {
        RemediationInner inner = this.serviceClient().getAtManagementGroup(managementGroupId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> deleteAtManagementGroupWithResponse(String managementGroupId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().deleteAtManagementGroupWithResponse(managementGroupId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation deleteAtManagementGroup(String managementGroupId, String remediationName) {
        RemediationInner inner = this.serviceClient().deleteAtManagementGroup(managementGroupId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtSubscription(String remediationName) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtSubscription(remediationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtSubscription(String remediationName, Integer top, Context context) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtSubscription(remediationName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public Response<Remediation> cancelAtSubscriptionWithResponse(String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().cancelAtSubscriptionWithResponse(remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation cancelAtSubscription(String remediationName) {
        RemediationInner inner = this.serviceClient().cancelAtSubscription(remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Remediation> list() {
        PagedIterable<RemediationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Remediation> list(Integer top, String filter, Context context) {
        PagedIterable<RemediationInner> inner = this.serviceClient().list(top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Remediation> createOrUpdateAtSubscriptionWithResponse(String remediationName, RemediationInner parameters, Context context) {
        Response<RemediationInner> inner = this.serviceClient().createOrUpdateAtSubscriptionWithResponse(remediationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation createOrUpdateAtSubscription(String remediationName, RemediationInner parameters) {
        RemediationInner inner = this.serviceClient().createOrUpdateAtSubscription(remediationName, parameters);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> getAtSubscriptionWithResponse(String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().getAtSubscriptionWithResponse(remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation getAtSubscription(String remediationName) {
        RemediationInner inner = this.serviceClient().getAtSubscription(remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> deleteAtSubscriptionWithResponse(String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().deleteAtSubscriptionWithResponse(remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation deleteAtSubscription(String remediationName) {
        RemediationInner inner = this.serviceClient().deleteAtSubscription(remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup(String resourceGroupName, String remediationName) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtResourceGroup(resourceGroupName, remediationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup(String resourceGroupName, String remediationName, Integer top, Context context) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtResourceGroup(resourceGroupName, remediationName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public Response<Remediation> cancelAtResourceGroupWithResponse(String resourceGroupName, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().cancelAtResourceGroupWithResponse(resourceGroupName, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation cancelAtResourceGroup(String resourceGroupName, String remediationName) {
        RemediationInner inner = this.serviceClient().cancelAtResourceGroup(resourceGroupName, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Remediation> listByResourceGroup(String resourceGroupName) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Remediation> listByResourceGroup(String resourceGroupName, Integer top, String filter, Context context) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Remediation> getByResourceGroupWithResponse(String resourceGroupName, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation getByResourceGroup(String resourceGroupName, String remediationName) {
        RemediationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> deleteByResourceGroupWithResponse(String resourceGroupName, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().deleteWithResponse(resourceGroupName, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation deleteByResourceGroup(String resourceGroupName, String remediationName) {
        RemediationInner inner = this.serviceClient().delete(resourceGroupName, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResource(String resourceId, String remediationName) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtResource(resourceId, remediationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RemediationDeployment> listDeploymentsAtResource(String resourceId, String remediationName, Integer top, Context context) {
        PagedIterable<RemediationDeploymentInner> inner = this.serviceClient().listDeploymentsAtResource(resourceId, remediationName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationDeploymentImpl((RemediationDeploymentInner)inner1, this.manager()));
    }

    @Override
    public Response<Remediation> cancelAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().cancelAtResourceWithResponse(resourceId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation cancelAtResource(String resourceId, String remediationName) {
        RemediationInner inner = this.serviceClient().cancelAtResource(resourceId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Remediation> listForResource(String resourceId) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listForResource(resourceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Remediation> listForResource(String resourceId, Integer top, String filter, Context context) {
        PagedIterable<RemediationInner> inner = this.serviceClient().listForResource(resourceId, top, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RemediationImpl((RemediationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Remediation> createOrUpdateAtResourceWithResponse(String resourceId, String remediationName, RemediationInner parameters, Context context) {
        Response<RemediationInner> inner = this.serviceClient().createOrUpdateAtResourceWithResponse(resourceId, remediationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation createOrUpdateAtResource(String resourceId, String remediationName, RemediationInner parameters) {
        RemediationInner inner = this.serviceClient().createOrUpdateAtResource(resourceId, remediationName, parameters);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> getAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().getAtResourceWithResponse(resourceId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation getAtResource(String resourceId, String remediationName) {
        RemediationInner inner = this.serviceClient().getAtResource(resourceId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Remediation> deleteAtResourceWithResponse(String resourceId, String remediationName, Context context) {
        Response<RemediationInner> inner = this.serviceClient().deleteAtResourceWithResponse(resourceId, remediationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemediationImpl((RemediationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Remediation deleteAtResource(String resourceId, String remediationName) {
        RemediationInner inner = this.serviceClient().deleteAtResource(resourceId, remediationName);
        if (inner != null) {
            return new RemediationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Remediation getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String remediationName = ResourceManagerUtils.getValueFromIdByName(id, "remediations");
        if (remediationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'remediations'.", id)));
        }
        return (Remediation)this.getByResourceGroupWithResponse(resourceGroupName, remediationName, Context.NONE).getValue();
    }

    @Override
    public Response<Remediation> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String remediationName = ResourceManagerUtils.getValueFromIdByName(id, "remediations");
        if (remediationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'remediations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, remediationName, context);
    }

    @Override
    public Remediation deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String remediationName = ResourceManagerUtils.getValueFromIdByName(id, "remediations");
        if (remediationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'remediations'.", id)));
        }
        return (Remediation)this.deleteByResourceGroupWithResponse(resourceGroupName, remediationName, Context.NONE).getValue();
    }

    @Override
    public Response<Remediation> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String remediationName = ResourceManagerUtils.getValueFromIdByName(id, "remediations");
        if (remediationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'remediations'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, remediationName, context);
    }

    private RemediationsClient serviceClient() {
        return this.innerClient;
    }

    private PolicyInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public RemediationImpl define(String name) {
        return new RemediationImpl(name, this.manager());
    }
}

