/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.policyinsights.fluent.models.AttestationInner;
import com.azure.resourcemanager.policyinsights.models.AttestationEvidence;
import com.azure.resourcemanager.policyinsights.models.ComplianceState;
import java.time.OffsetDateTime;
import java.util.List;

public interface Attestation {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String policyAssignmentId();

    public String policyDefinitionReferenceId();

    public ComplianceState complianceState();

    public OffsetDateTime expiresOn();

    public String owner();

    public String comments();

    public List<AttestationEvidence> evidence();

    public String provisioningState();

    public OffsetDateTime lastComplianceStateChangeAt();

    public OffsetDateTime assessmentDate();

    public Object metadata();

    public String resourceGroupName();

    public AttestationInner innerModel();

    public Update update();

    public Attestation refresh();

    public Attestation refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithMetadata {
            public Update withMetadata(Object var1);
        }

        public static interface WithAssessmentDate {
            public Update withAssessmentDate(OffsetDateTime var1);
        }

        public static interface WithEvidence {
            public Update withEvidence(List<AttestationEvidence> var1);
        }

        public static interface WithComments {
            public Update withComments(String var1);
        }

        public static interface WithOwner {
            public Update withOwner(String var1);
        }

        public static interface WithExpiresOn {
            public Update withExpiresOn(OffsetDateTime var1);
        }

        public static interface WithComplianceState {
            public Update withComplianceState(ComplianceState var1);
        }

        public static interface WithPolicyDefinitionReferenceId {
            public Update withPolicyDefinitionReferenceId(String var1);
        }

        public static interface WithPolicyAssignmentId {
            public Update withPolicyAssignmentId(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPolicyAssignmentId,
    UpdateStages.WithPolicyDefinitionReferenceId,
    UpdateStages.WithComplianceState,
    UpdateStages.WithExpiresOn,
    UpdateStages.WithOwner,
    UpdateStages.WithComments,
    UpdateStages.WithEvidence,
    UpdateStages.WithAssessmentDate,
    UpdateStages.WithMetadata {
        public Attestation apply();

        public Attestation apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMetadata {
            public WithCreate withMetadata(Object var1);
        }

        public static interface WithAssessmentDate {
            public WithCreate withAssessmentDate(OffsetDateTime var1);
        }

        public static interface WithEvidence {
            public WithCreate withEvidence(List<AttestationEvidence> var1);
        }

        public static interface WithComments {
            public WithCreate withComments(String var1);
        }

        public static interface WithOwner {
            public WithCreate withOwner(String var1);
        }

        public static interface WithExpiresOn {
            public WithCreate withExpiresOn(OffsetDateTime var1);
        }

        public static interface WithComplianceState {
            public WithCreate withComplianceState(ComplianceState var1);
        }

        public static interface WithPolicyDefinitionReferenceId {
            public WithCreate withPolicyDefinitionReferenceId(String var1);
        }

        public static interface WithCreate
        extends WithPolicyDefinitionReferenceId,
        WithComplianceState,
        WithExpiresOn,
        WithOwner,
        WithComments,
        WithEvidence,
        WithAssessmentDate,
        WithMetadata {
            public Attestation create();

            public Attestation create(Context var1);
        }

        public static interface WithPolicyAssignmentId {
            public WithCreate withPolicyAssignmentId(String var1);
        }

        public static interface WithResourceGroup {
            public WithPolicyAssignmentId withExistingResourceGroup(String var1);
        }

        public static interface Blank
        extends WithResourceGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithPolicyAssignmentId,
    DefinitionStages.WithCreate {
    }
}

