/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.CheckRestrictionsResourceDetails;
import com.azure.resourcemanager.policyinsights.models.PendingField;
import java.io.IOException;
import java.util.List;

public final class CheckManagementGroupRestrictionsRequest
implements JsonSerializable<CheckManagementGroupRestrictionsRequest> {
    private CheckRestrictionsResourceDetails resourceDetails;
    private List<PendingField> pendingFields;

    public CheckRestrictionsResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public CheckManagementGroupRestrictionsRequest withResourceDetails(CheckRestrictionsResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    public List<PendingField> pendingFields() {
        return this.pendingFields;
    }

    public CheckManagementGroupRestrictionsRequest withPendingFields(List<PendingField> pendingFields) {
        this.pendingFields = pendingFields;
        return this;
    }

    public void validate() {
        if (this.resourceDetails() != null) {
            this.resourceDetails().validate();
        }
        if (this.pendingFields() != null) {
            this.pendingFields().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceDetails", (JsonSerializable)this.resourceDetails);
        jsonWriter.writeArrayField("pendingFields", this.pendingFields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CheckManagementGroupRestrictionsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CheckManagementGroupRestrictionsRequest)jsonReader.readObject(reader -> {
            CheckManagementGroupRestrictionsRequest deserializedCheckManagementGroupRestrictionsRequest = new CheckManagementGroupRestrictionsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceDetails".equals(fieldName)) {
                    deserializedCheckManagementGroupRestrictionsRequest.resourceDetails = CheckRestrictionsResourceDetails.fromJson(reader);
                    continue;
                }
                if ("pendingFields".equals(fieldName)) {
                    List pendingFields;
                    deserializedCheckManagementGroupRestrictionsRequest.pendingFields = pendingFields = reader.readArray(reader1 -> PendingField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckManagementGroupRestrictionsRequest;
        });
    }
}

