/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.CheckRestrictionsResourceDetails;
import com.azure.resourcemanager.policyinsights.models.PendingField;
import java.io.IOException;
import java.util.List;

public final class CheckRestrictionsRequest
implements JsonSerializable<CheckRestrictionsRequest> {
    private CheckRestrictionsResourceDetails resourceDetails;
    private List<PendingField> pendingFields;
    private static final ClientLogger LOGGER = new ClientLogger(CheckRestrictionsRequest.class);

    public CheckRestrictionsResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public CheckRestrictionsRequest withResourceDetails(CheckRestrictionsResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    public List<PendingField> pendingFields() {
        return this.pendingFields;
    }

    public CheckRestrictionsRequest withPendingFields(List<PendingField> pendingFields) {
        this.pendingFields = pendingFields;
        return this;
    }

    public void validate() {
        if (this.resourceDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceDetails in model CheckRestrictionsRequest"));
        }
        this.resourceDetails().validate();
        if (this.pendingFields() != null) {
            this.pendingFields().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceDetails", (JsonSerializable)this.resourceDetails);
        jsonWriter.writeArrayField("pendingFields", this.pendingFields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CheckRestrictionsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CheckRestrictionsRequest)jsonReader.readObject(reader -> {
            CheckRestrictionsRequest deserializedCheckRestrictionsRequest = new CheckRestrictionsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceDetails".equals(fieldName)) {
                    deserializedCheckRestrictionsRequest.resourceDetails = CheckRestrictionsResourceDetails.fromJson(reader);
                    continue;
                }
                if ("pendingFields".equals(fieldName)) {
                    List pendingFields;
                    deserializedCheckRestrictionsRequest.pendingFields = pendingFields = reader.readArray(reader1 -> PendingField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckRestrictionsRequest;
        });
    }
}

