/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ComponentEventDetails
implements JsonSerializable<ComponentEventDetails> {
    private String id;
    private String type;
    private String name;
    private OffsetDateTime timestamp;
    private String tenantId;
    private String principalOid;
    private String policyDefinitionAction;
    private Map<String, Object> additionalProperties;

    public String id() {
        return this.id;
    }

    public ComponentEventDetails withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public ComponentEventDetails withType(String type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ComponentEventDetails withName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ComponentEventDetails withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ComponentEventDetails withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String principalOid() {
        return this.principalOid;
    }

    public ComponentEventDetails withPrincipalOid(String principalOid) {
        this.principalOid = principalOid;
        return this;
    }

    public String policyDefinitionAction() {
        return this.policyDefinitionAction;
    }

    public ComponentEventDetails withPolicyDefinitionAction(String policyDefinitionAction) {
        this.policyDefinitionAction = policyDefinitionAction;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ComponentEventDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("principalOid", this.principalOid);
        jsonWriter.writeStringField("policyDefinitionAction", this.policyDefinitionAction);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ComponentEventDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentEventDetails)jsonReader.readObject(reader -> {
            ComponentEventDetails deserializedComponentEventDetails = new ComponentEventDetails();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedComponentEventDetails.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedComponentEventDetails.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedComponentEventDetails.name = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedComponentEventDetails.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedComponentEventDetails.tenantId = reader.getString();
                    continue;
                }
                if ("principalOid".equals(fieldName)) {
                    deserializedComponentEventDetails.principalOid = reader.getString();
                    continue;
                }
                if ("policyDefinitionAction".equals(fieldName)) {
                    deserializedComponentEventDetails.policyDefinitionAction = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedComponentEventDetails.additionalProperties = additionalProperties;
            return deserializedComponentEventDetails;
        });
    }
}

