/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.ComponentPolicyEvaluationDetails;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ComponentPolicyState
implements JsonSerializable<ComponentPolicyState> {
    private String odataId;
    private String odataContext;
    private OffsetDateTime timestamp;
    private String componentId;
    private String componentType;
    private String componentName;
    private String resourceId;
    private String policyAssignmentId;
    private String policyDefinitionId;
    private String subscriptionId;
    private String resourceType;
    private String resourceLocation;
    private String resourceGroup;
    private String policyAssignmentName;
    private String policyAssignmentOwner;
    private String policyAssignmentParameters;
    private String policyAssignmentScope;
    private String policyDefinitionName;
    private String policyDefinitionAction;
    private String policyDefinitionCategory;
    private String policySetDefinitionId;
    private String policySetDefinitionName;
    private String policySetDefinitionOwner;
    private String policySetDefinitionCategory;
    private String policySetDefinitionParameters;
    private String policyDefinitionReferenceId;
    private String complianceState;
    private ComponentPolicyEvaluationDetails policyEvaluationDetails;
    private List<String> policyDefinitionGroupNames;
    private String policyDefinitionVersion;
    private String policySetDefinitionVersion;
    private String policyAssignmentVersion;
    private Map<String, Object> additionalProperties;

    public String odataId() {
        return this.odataId;
    }

    public String odataContext() {
        return this.odataContext;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public String componentId() {
        return this.componentId;
    }

    public String componentType() {
        return this.componentType;
    }

    public String componentName() {
        return this.componentName;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String policyAssignmentName() {
        return this.policyAssignmentName;
    }

    public String policyAssignmentOwner() {
        return this.policyAssignmentOwner;
    }

    public String policyAssignmentParameters() {
        return this.policyAssignmentParameters;
    }

    public String policyAssignmentScope() {
        return this.policyAssignmentScope;
    }

    public String policyDefinitionName() {
        return this.policyDefinitionName;
    }

    public String policyDefinitionAction() {
        return this.policyDefinitionAction;
    }

    public String policyDefinitionCategory() {
        return this.policyDefinitionCategory;
    }

    public String policySetDefinitionId() {
        return this.policySetDefinitionId;
    }

    public String policySetDefinitionName() {
        return this.policySetDefinitionName;
    }

    public String policySetDefinitionOwner() {
        return this.policySetDefinitionOwner;
    }

    public String policySetDefinitionCategory() {
        return this.policySetDefinitionCategory;
    }

    public String policySetDefinitionParameters() {
        return this.policySetDefinitionParameters;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public String complianceState() {
        return this.complianceState;
    }

    public ComponentPolicyEvaluationDetails policyEvaluationDetails() {
        return this.policyEvaluationDetails;
    }

    public ComponentPolicyState withPolicyEvaluationDetails(ComponentPolicyEvaluationDetails policyEvaluationDetails) {
        this.policyEvaluationDetails = policyEvaluationDetails;
        return this;
    }

    public List<String> policyDefinitionGroupNames() {
        return this.policyDefinitionGroupNames;
    }

    public String policyDefinitionVersion() {
        return this.policyDefinitionVersion;
    }

    public String policySetDefinitionVersion() {
        return this.policySetDefinitionVersion;
    }

    public String policyAssignmentVersion() {
        return this.policyAssignmentVersion;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ComponentPolicyState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.policyEvaluationDetails() != null) {
            this.policyEvaluationDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policyEvaluationDetails", (JsonSerializable)this.policyEvaluationDetails);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ComponentPolicyState fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentPolicyState)jsonReader.readObject(reader -> {
            ComponentPolicyState deserializedComponentPolicyState = new ComponentPolicyState();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.id".equals(fieldName)) {
                    deserializedComponentPolicyState.odataId = reader.getString();
                    continue;
                }
                if ("@odata.context".equals(fieldName)) {
                    deserializedComponentPolicyState.odataContext = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedComponentPolicyState.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("componentId".equals(fieldName)) {
                    deserializedComponentPolicyState.componentId = reader.getString();
                    continue;
                }
                if ("componentType".equals(fieldName)) {
                    deserializedComponentPolicyState.componentType = reader.getString();
                    continue;
                }
                if ("componentName".equals(fieldName)) {
                    deserializedComponentPolicyState.componentName = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedComponentPolicyState.resourceId = reader.getString();
                    continue;
                }
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedComponentPolicyState.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedComponentPolicyState.resourceType = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedComponentPolicyState.resourceLocation = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedComponentPolicyState.resourceGroup = reader.getString();
                    continue;
                }
                if ("policyAssignmentName".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentName = reader.getString();
                    continue;
                }
                if ("policyAssignmentOwner".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentOwner = reader.getString();
                    continue;
                }
                if ("policyAssignmentParameters".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentParameters = reader.getString();
                    continue;
                }
                if ("policyAssignmentScope".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentScope = reader.getString();
                    continue;
                }
                if ("policyDefinitionName".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionName = reader.getString();
                    continue;
                }
                if ("policyDefinitionAction".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionAction = reader.getString();
                    continue;
                }
                if ("policyDefinitionCategory".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionId".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionId = reader.getString();
                    continue;
                }
                if ("policySetDefinitionName".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionName = reader.getString();
                    continue;
                }
                if ("policySetDefinitionOwner".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionOwner = reader.getString();
                    continue;
                }
                if ("policySetDefinitionCategory".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionCategory = reader.getString();
                    continue;
                }
                if ("policySetDefinitionParameters".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionParameters = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedComponentPolicyState.complianceState = reader.getString();
                    continue;
                }
                if ("policyEvaluationDetails".equals(fieldName)) {
                    deserializedComponentPolicyState.policyEvaluationDetails = ComponentPolicyEvaluationDetails.fromJson(reader);
                    continue;
                }
                if ("policyDefinitionGroupNames".equals(fieldName)) {
                    List policyDefinitionGroupNames;
                    deserializedComponentPolicyState.policyDefinitionGroupNames = policyDefinitionGroupNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("policyDefinitionVersion".equals(fieldName)) {
                    deserializedComponentPolicyState.policyDefinitionVersion = reader.getString();
                    continue;
                }
                if ("policySetDefinitionVersion".equals(fieldName)) {
                    deserializedComponentPolicyState.policySetDefinitionVersion = reader.getString();
                    continue;
                }
                if ("policyAssignmentVersion".equals(fieldName)) {
                    deserializedComponentPolicyState.policyAssignmentVersion = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedComponentPolicyState.additionalProperties = additionalProperties;
            return deserializedComponentPolicyState;
        });
    }
}

