/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ComponentStateDetails
implements JsonSerializable<ComponentStateDetails> {
    private String id;
    private String type;
    private String name;
    private OffsetDateTime timestamp;
    private String complianceState;
    private Map<String, Object> additionalProperties;

    public String id() {
        return this.id;
    }

    public ComponentStateDetails withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public ComponentStateDetails withType(String type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ComponentStateDetails withName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ComponentStateDetails withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String complianceState() {
        return this.complianceState;
    }

    public ComponentStateDetails withComplianceState(String complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ComponentStateDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("complianceState", this.complianceState);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ComponentStateDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentStateDetails)jsonReader.readObject(reader -> {
            ComponentStateDetails deserializedComponentStateDetails = new ComponentStateDetails();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedComponentStateDetails.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedComponentStateDetails.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedComponentStateDetails.name = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedComponentStateDetails.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedComponentStateDetails.complianceState = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedComponentStateDetails.additionalProperties = additionalProperties;
            return deserializedComponentStateDetails;
        });
    }
}

