/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.FieldRestrictionResult;
import com.azure.resourcemanager.policyinsights.models.PolicyReference;
import java.io.IOException;
import java.util.List;

public final class FieldRestriction
implements JsonSerializable<FieldRestriction> {
    private FieldRestrictionResult result;
    private String defaultValue;
    private List<String> values;
    private PolicyReference policy;

    public FieldRestrictionResult result() {
        return this.result;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public List<String> values() {
        return this.values;
    }

    public PolicyReference policy() {
        return this.policy;
    }

    public void validate() {
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static FieldRestriction fromJson(JsonReader jsonReader) throws IOException {
        return (FieldRestriction)jsonReader.readObject(reader -> {
            FieldRestriction deserializedFieldRestriction = new FieldRestriction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("result".equals(fieldName)) {
                    deserializedFieldRestriction.result = FieldRestrictionResult.fromString(reader.getString());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedFieldRestriction.defaultValue = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedFieldRestriction.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedFieldRestriction.policy = PolicyReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFieldRestriction;
        });
    }
}

