/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.FieldRestriction;
import java.io.IOException;
import java.util.List;

public final class FieldRestrictions
implements JsonSerializable<FieldRestrictions> {
    private String field;
    private List<FieldRestriction> restrictions;

    public String field() {
        return this.field;
    }

    public List<FieldRestriction> restrictions() {
        return this.restrictions;
    }

    public FieldRestrictions withRestrictions(List<FieldRestriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FieldRestrictions fromJson(JsonReader jsonReader) throws IOException {
        return (FieldRestrictions)jsonReader.readObject(reader -> {
            FieldRestrictions deserializedFieldRestrictions = new FieldRestrictions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("field".equals(fieldName)) {
                    deserializedFieldRestrictions.field = reader.getString();
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedFieldRestrictions.restrictions = restrictions = reader.readArray(reader1 -> FieldRestriction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFieldRestrictions;
        });
    }
}

