/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.OperationDisplay;
import java.io.IOException;

public final class Operation
implements JsonSerializable<Operation> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;

    public String name() {
        return this.name;
    }

    public Operation withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public Operation withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public Operation withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        return jsonWriter.writeEndObject();
    }

    public static Operation fromJson(JsonReader jsonReader) throws IOException {
        return (Operation)jsonReader.readObject(reader -> {
            Operation deserializedOperation = new Operation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperation.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperation.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperation.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperation;
        });
    }
}

