/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PendingField
implements JsonSerializable<PendingField> {
    private String field;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(PendingField.class);

    public String field() {
        return this.field;
    }

    public PendingField withField(String field) {
        this.field = field;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public PendingField withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.field() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property field in model PendingField"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("field", this.field);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PendingField fromJson(JsonReader jsonReader) throws IOException {
        return (PendingField)jsonReader.readObject(reader -> {
            PendingField deserializedPendingField = new PendingField();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("field".equals(fieldName)) {
                    deserializedPendingField.field = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedPendingField.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPendingField;
        });
    }
}

