/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.PolicyDefinitionSummary;
import com.azure.resourcemanager.policyinsights.models.PolicyGroupSummary;
import com.azure.resourcemanager.policyinsights.models.SummaryResults;
import java.io.IOException;
import java.util.List;

public final class PolicyAssignmentSummary
implements JsonSerializable<PolicyAssignmentSummary> {
    private String policyAssignmentId;
    private String policySetDefinitionId;
    private SummaryResults results;
    private List<PolicyDefinitionSummary> policyDefinitions;
    private List<PolicyGroupSummary> policyGroups;

    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    public PolicyAssignmentSummary withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String policySetDefinitionId() {
        return this.policySetDefinitionId;
    }

    public PolicyAssignmentSummary withPolicySetDefinitionId(String policySetDefinitionId) {
        this.policySetDefinitionId = policySetDefinitionId;
        return this;
    }

    public SummaryResults results() {
        return this.results;
    }

    public PolicyAssignmentSummary withResults(SummaryResults results) {
        this.results = results;
        return this;
    }

    public List<PolicyDefinitionSummary> policyDefinitions() {
        return this.policyDefinitions;
    }

    public PolicyAssignmentSummary withPolicyDefinitions(List<PolicyDefinitionSummary> policyDefinitions) {
        this.policyDefinitions = policyDefinitions;
        return this;
    }

    public List<PolicyGroupSummary> policyGroups() {
        return this.policyGroups;
    }

    public PolicyAssignmentSummary withPolicyGroups(List<PolicyGroupSummary> policyGroups) {
        this.policyGroups = policyGroups;
        return this;
    }

    public void validate() {
        if (this.results() != null) {
            this.results().validate();
        }
        if (this.policyDefinitions() != null) {
            this.policyDefinitions().forEach(e -> e.validate());
        }
        if (this.policyGroups() != null) {
            this.policyGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policySetDefinitionId", this.policySetDefinitionId);
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeArrayField("policyDefinitions", this.policyDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("policyGroups", this.policyGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentSummary fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentSummary)jsonReader.readObject(reader -> {
            PolicyAssignmentSummary deserializedPolicyAssignmentSummary = new PolicyAssignmentSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyAssignmentSummary.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policySetDefinitionId".equals(fieldName)) {
                    deserializedPolicyAssignmentSummary.policySetDefinitionId = reader.getString();
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedPolicyAssignmentSummary.results = SummaryResults.fromJson(reader);
                    continue;
                }
                if ("policyDefinitions".equals(fieldName)) {
                    List policyDefinitions;
                    deserializedPolicyAssignmentSummary.policyDefinitions = policyDefinitions = reader.readArray(reader1 -> PolicyDefinitionSummary.fromJson(reader1));
                    continue;
                }
                if ("policyGroups".equals(fieldName)) {
                    List policyGroups;
                    deserializedPolicyAssignmentSummary.policyGroups = policyGroups = reader.readArray(reader1 -> PolicyGroupSummary.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentSummary;
        });
    }
}

