/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.SummaryResults;
import java.io.IOException;
import java.util.List;

public final class PolicyDefinitionSummary
implements JsonSerializable<PolicyDefinitionSummary> {
    private String policyDefinitionId;
    private String policyDefinitionReferenceId;
    private List<String> policyDefinitionGroupNames;
    private String effect;
    private SummaryResults results;

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyDefinitionSummary withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyDefinitionSummary withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public List<String> policyDefinitionGroupNames() {
        return this.policyDefinitionGroupNames;
    }

    public PolicyDefinitionSummary withPolicyDefinitionGroupNames(List<String> policyDefinitionGroupNames) {
        this.policyDefinitionGroupNames = policyDefinitionGroupNames;
        return this;
    }

    public String effect() {
        return this.effect;
    }

    public PolicyDefinitionSummary withEffect(String effect) {
        this.effect = effect;
        return this;
    }

    public SummaryResults results() {
        return this.results;
    }

    public PolicyDefinitionSummary withResults(SummaryResults results) {
        this.results = results;
        return this;
    }

    public void validate() {
        if (this.results() != null) {
            this.results().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeArrayField("policyDefinitionGroupNames", this.policyDefinitionGroupNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("effect", this.effect);
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static PolicyDefinitionSummary fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyDefinitionSummary)jsonReader.readObject(reader -> {
            PolicyDefinitionSummary deserializedPolicyDefinitionSummary = new PolicyDefinitionSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyDefinitionSummary.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyDefinitionSummary.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("policyDefinitionGroupNames".equals(fieldName)) {
                    List policyDefinitionGroupNames;
                    deserializedPolicyDefinitionSummary.policyDefinitionGroupNames = policyDefinitionGroupNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("effect".equals(fieldName)) {
                    deserializedPolicyDefinitionSummary.effect = reader.getString();
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedPolicyDefinitionSummary.results = SummaryResults.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDefinitionSummary;
        });
    }
}

