/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.PolicyEvaluationDetails;
import com.azure.resourcemanager.policyinsights.models.PolicyReference;
import java.io.IOException;

public final class PolicyEvaluationResult
implements JsonSerializable<PolicyEvaluationResult> {
    private PolicyReference policyInfo;
    private String evaluationResult;
    private PolicyEvaluationDetails evaluationDetails;

    public PolicyReference policyInfo() {
        return this.policyInfo;
    }

    public String evaluationResult() {
        return this.evaluationResult;
    }

    public PolicyEvaluationDetails evaluationDetails() {
        return this.evaluationDetails;
    }

    public void validate() {
        if (this.policyInfo() != null) {
            this.policyInfo().validate();
        }
        if (this.evaluationDetails() != null) {
            this.evaluationDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PolicyEvaluationResult fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyEvaluationResult)jsonReader.readObject(reader -> {
            PolicyEvaluationResult deserializedPolicyEvaluationResult = new PolicyEvaluationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyInfo".equals(fieldName)) {
                    deserializedPolicyEvaluationResult.policyInfo = PolicyReference.fromJson(reader);
                    continue;
                }
                if ("evaluationResult".equals(fieldName)) {
                    deserializedPolicyEvaluationResult.evaluationResult = reader.getString();
                    continue;
                }
                if ("evaluationDetails".equals(fieldName)) {
                    deserializedPolicyEvaluationResult.evaluationDetails = PolicyEvaluationDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyEvaluationResult;
        });
    }
}

