/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.fluent.models.PolicyStateInner;
import java.io.IOException;
import java.util.List;

public final class PolicyStatesQueryResults
implements JsonSerializable<PolicyStatesQueryResults> {
    private String odataContext;
    private Integer odataCount;
    private String odataNextLink;
    private List<PolicyStateInner> value;

    public String odataContext() {
        return this.odataContext;
    }

    public PolicyStatesQueryResults withOdataContext(String odataContext) {
        this.odataContext = odataContext;
        return this;
    }

    public Integer odataCount() {
        return this.odataCount;
    }

    public PolicyStatesQueryResults withOdataCount(Integer odataCount) {
        this.odataCount = odataCount;
        return this;
    }

    public String odataNextLink() {
        return this.odataNextLink;
    }

    public PolicyStatesQueryResults withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    public List<PolicyStateInner> value() {
        return this.value;
    }

    public PolicyStatesQueryResults withValue(List<PolicyStateInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.context", this.odataContext);
        jsonWriter.writeNumberField("@odata.count", (Number)this.odataCount);
        jsonWriter.writeStringField("@odata.nextLink", this.odataNextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyStatesQueryResults fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyStatesQueryResults)jsonReader.readObject(reader -> {
            PolicyStatesQueryResults deserializedPolicyStatesQueryResults = new PolicyStatesQueryResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.context".equals(fieldName)) {
                    deserializedPolicyStatesQueryResults.odataContext = reader.getString();
                    continue;
                }
                if ("@odata.count".equals(fieldName)) {
                    deserializedPolicyStatesQueryResults.odataCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("@odata.nextLink".equals(fieldName)) {
                    deserializedPolicyStatesQueryResults.odataNextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedPolicyStatesQueryResults.value = value = reader.readArray(reader1 -> PolicyStateInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyStatesQueryResults;
        });
    }
}

