/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.policyinsights.fluent.models.RemediationInner;
import com.azure.resourcemanager.policyinsights.models.RemediationDeployment;
import com.azure.resourcemanager.policyinsights.models.RemediationDeploymentSummary;
import com.azure.resourcemanager.policyinsights.models.RemediationFilters;
import com.azure.resourcemanager.policyinsights.models.RemediationPropertiesFailureThreshold;
import com.azure.resourcemanager.policyinsights.models.ResourceDiscoveryMode;
import java.time.OffsetDateTime;

public interface Remediation {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String policyAssignmentId();

    public String policyDefinitionReferenceId();

    public ResourceDiscoveryMode resourceDiscoveryMode();

    public String provisioningState();

    public OffsetDateTime createdOn();

    public OffsetDateTime lastUpdatedOn();

    public RemediationFilters filters();

    public RemediationDeploymentSummary deploymentStatus();

    public String statusMessage();

    public String correlationId();

    public Integer resourceCount();

    public Integer parallelDeployments();

    public RemediationPropertiesFailureThreshold failureThreshold();

    public String resourceGroupName();

    public RemediationInner innerModel();

    public Update update();

    public Remediation refresh();

    public Remediation refresh(Context var1);

    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup();

    public PagedIterable<RemediationDeployment> listDeploymentsAtResourceGroup(Integer var1, Context var2);

    public Response<Remediation> cancelAtResourceGroupWithResponse(Context var1);

    public Remediation cancelAtResourceGroup();

    public static interface UpdateStages {

        public static interface WithFailureThreshold {
            public Update withFailureThreshold(RemediationPropertiesFailureThreshold var1);
        }

        public static interface WithParallelDeployments {
            public Update withParallelDeployments(Integer var1);
        }

        public static interface WithResourceCount {
            public Update withResourceCount(Integer var1);
        }

        public static interface WithFilters {
            public Update withFilters(RemediationFilters var1);
        }

        public static interface WithResourceDiscoveryMode {
            public Update withResourceDiscoveryMode(ResourceDiscoveryMode var1);
        }

        public static interface WithPolicyDefinitionReferenceId {
            public Update withPolicyDefinitionReferenceId(String var1);
        }

        public static interface WithPolicyAssignmentId {
            public Update withPolicyAssignmentId(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPolicyAssignmentId,
    UpdateStages.WithPolicyDefinitionReferenceId,
    UpdateStages.WithResourceDiscoveryMode,
    UpdateStages.WithFilters,
    UpdateStages.WithResourceCount,
    UpdateStages.WithParallelDeployments,
    UpdateStages.WithFailureThreshold {
        public Remediation apply();

        public Remediation apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithFailureThreshold {
            public WithCreate withFailureThreshold(RemediationPropertiesFailureThreshold var1);
        }

        public static interface WithParallelDeployments {
            public WithCreate withParallelDeployments(Integer var1);
        }

        public static interface WithResourceCount {
            public WithCreate withResourceCount(Integer var1);
        }

        public static interface WithFilters {
            public WithCreate withFilters(RemediationFilters var1);
        }

        public static interface WithResourceDiscoveryMode {
            public WithCreate withResourceDiscoveryMode(ResourceDiscoveryMode var1);
        }

        public static interface WithPolicyDefinitionReferenceId {
            public WithCreate withPolicyDefinitionReferenceId(String var1);
        }

        public static interface WithPolicyAssignmentId {
            public WithCreate withPolicyAssignmentId(String var1);
        }

        public static interface WithCreate
        extends WithPolicyAssignmentId,
        WithPolicyDefinitionReferenceId,
        WithResourceDiscoveryMode,
        WithFilters,
        WithResourceCount,
        WithParallelDeployments,
        WithFailureThreshold {
            public Remediation create();

            public Remediation create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface Blank
        extends WithResourceGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

