/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.PolicyAssignmentSummary;
import com.azure.resourcemanager.policyinsights.models.SummaryResults;
import java.io.IOException;
import java.util.List;

public final class Summary
implements JsonSerializable<Summary> {
    private String odataId;
    private String odataContext;
    private SummaryResults results;
    private List<PolicyAssignmentSummary> policyAssignments;

    public String odataId() {
        return this.odataId;
    }

    public Summary withOdataId(String odataId) {
        this.odataId = odataId;
        return this;
    }

    public String odataContext() {
        return this.odataContext;
    }

    public Summary withOdataContext(String odataContext) {
        this.odataContext = odataContext;
        return this;
    }

    public SummaryResults results() {
        return this.results;
    }

    public Summary withResults(SummaryResults results) {
        this.results = results;
        return this;
    }

    public List<PolicyAssignmentSummary> policyAssignments() {
        return this.policyAssignments;
    }

    public Summary withPolicyAssignments(List<PolicyAssignmentSummary> policyAssignments) {
        this.policyAssignments = policyAssignments;
        return this;
    }

    public void validate() {
        if (this.results() != null) {
            this.results().validate();
        }
        if (this.policyAssignments() != null) {
            this.policyAssignments().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.id", this.odataId);
        jsonWriter.writeStringField("@odata.context", this.odataContext);
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeArrayField("policyAssignments", this.policyAssignments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Summary fromJson(JsonReader jsonReader) throws IOException {
        return (Summary)jsonReader.readObject(reader -> {
            Summary deserializedSummary = new Summary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.id".equals(fieldName)) {
                    deserializedSummary.odataId = reader.getString();
                    continue;
                }
                if ("@odata.context".equals(fieldName)) {
                    deserializedSummary.odataContext = reader.getString();
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedSummary.results = SummaryResults.fromJson(reader);
                    continue;
                }
                if ("policyAssignments".equals(fieldName)) {
                    List policyAssignments;
                    deserializedSummary.policyAssignments = policyAssignments = reader.readArray(reader1 -> PolicyAssignmentSummary.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSummary;
        });
    }
}

