/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.ComplianceDetail;
import java.io.IOException;
import java.util.List;

public final class SummaryResults
implements JsonSerializable<SummaryResults> {
    private String queryResultsUri;
    private Integer nonCompliantResources;
    private Integer nonCompliantPolicies;
    private List<ComplianceDetail> resourceDetails;
    private List<ComplianceDetail> policyDetails;
    private List<ComplianceDetail> policyGroupDetails;

    public String queryResultsUri() {
        return this.queryResultsUri;
    }

    public SummaryResults withQueryResultsUri(String queryResultsUri) {
        this.queryResultsUri = queryResultsUri;
        return this;
    }

    public Integer nonCompliantResources() {
        return this.nonCompliantResources;
    }

    public SummaryResults withNonCompliantResources(Integer nonCompliantResources) {
        this.nonCompliantResources = nonCompliantResources;
        return this;
    }

    public Integer nonCompliantPolicies() {
        return this.nonCompliantPolicies;
    }

    public SummaryResults withNonCompliantPolicies(Integer nonCompliantPolicies) {
        this.nonCompliantPolicies = nonCompliantPolicies;
        return this;
    }

    public List<ComplianceDetail> resourceDetails() {
        return this.resourceDetails;
    }

    public SummaryResults withResourceDetails(List<ComplianceDetail> resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    public List<ComplianceDetail> policyDetails() {
        return this.policyDetails;
    }

    public SummaryResults withPolicyDetails(List<ComplianceDetail> policyDetails) {
        this.policyDetails = policyDetails;
        return this;
    }

    public List<ComplianceDetail> policyGroupDetails() {
        return this.policyGroupDetails;
    }

    public SummaryResults withPolicyGroupDetails(List<ComplianceDetail> policyGroupDetails) {
        this.policyGroupDetails = policyGroupDetails;
        return this;
    }

    public void validate() {
        if (this.resourceDetails() != null) {
            this.resourceDetails().forEach(e -> e.validate());
        }
        if (this.policyDetails() != null) {
            this.policyDetails().forEach(e -> e.validate());
        }
        if (this.policyGroupDetails() != null) {
            this.policyGroupDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryResultsUri", this.queryResultsUri);
        jsonWriter.writeNumberField("nonCompliantResources", (Number)this.nonCompliantResources);
        jsonWriter.writeNumberField("nonCompliantPolicies", (Number)this.nonCompliantPolicies);
        jsonWriter.writeArrayField("resourceDetails", this.resourceDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("policyDetails", this.policyDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("policyGroupDetails", this.policyGroupDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SummaryResults fromJson(JsonReader jsonReader) throws IOException {
        return (SummaryResults)jsonReader.readObject(reader -> {
            SummaryResults deserializedSummaryResults = new SummaryResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryResultsUri".equals(fieldName)) {
                    deserializedSummaryResults.queryResultsUri = reader.getString();
                    continue;
                }
                if ("nonCompliantResources".equals(fieldName)) {
                    deserializedSummaryResults.nonCompliantResources = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("nonCompliantPolicies".equals(fieldName)) {
                    deserializedSummaryResults.nonCompliantPolicies = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resourceDetails".equals(fieldName)) {
                    List resourceDetails;
                    deserializedSummaryResults.resourceDetails = resourceDetails = reader.readArray(reader1 -> ComplianceDetail.fromJson(reader1));
                    continue;
                }
                if ("policyDetails".equals(fieldName)) {
                    List policyDetails;
                    deserializedSummaryResults.policyDetails = policyDetails = reader.readArray(reader1 -> ComplianceDetail.fromJson(reader1));
                    continue;
                }
                if ("policyGroupDetails".equals(fieldName)) {
                    List policyGroupDetails;
                    deserializedSummaryResults.policyGroupDetails = policyGroupDetails = reader.readArray(reader1 -> ComplianceDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSummaryResults;
        });
    }
}

