/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.policyinsights.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.policyinsights.models.PolicyDetails;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class TrackedResourceModificationDetails
implements JsonSerializable<TrackedResourceModificationDetails> {
    private PolicyDetails policyDetails;
    private String deploymentId;
    private OffsetDateTime deploymentTime;

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public OffsetDateTime deploymentTime() {
        return this.deploymentTime;
    }

    public void validate() {
        if (this.policyDetails() != null) {
            this.policyDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static TrackedResourceModificationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (TrackedResourceModificationDetails)jsonReader.readObject(reader -> {
            TrackedResourceModificationDetails deserializedTrackedResourceModificationDetails = new TrackedResourceModificationDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDetails".equals(fieldName)) {
                    deserializedTrackedResourceModificationDetails.policyDetails = PolicyDetails.fromJson(reader);
                    continue;
                }
                if ("deploymentId".equals(fieldName)) {
                    deserializedTrackedResourceModificationDetails.deploymentId = reader.getString();
                    continue;
                }
                if ("deploymentTime".equals(fieldName)) {
                    deserializedTrackedResourceModificationDetails.deploymentTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrackedResourceModificationDetails;
        });
    }
}

