/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdministratorsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ActiveDirectoryAdministratorInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ActiveDirectoryAdministratorImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAdministrator;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Administrators;

public final class AdministratorsImpl
implements Administrators {
    private static final ClientLogger LOGGER = new ClientLogger(AdministratorsImpl.class);
    private final AdministratorsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public AdministratorsImpl(AdministratorsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String objectId) {
        this.serviceClient().delete(resourceGroupName, serverName, objectId);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String objectId, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, objectId, context);
    }

    @Override
    public Response<ActiveDirectoryAdministrator> getWithResponse(String resourceGroupName, String serverName, String objectId, Context context) {
        Response<ActiveDirectoryAdministratorInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, objectId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ActiveDirectoryAdministratorImpl((ActiveDirectoryAdministratorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ActiveDirectoryAdministrator get(String resourceGroupName, String serverName, String objectId) {
        ActiveDirectoryAdministratorInner inner = this.serviceClient().get(resourceGroupName, serverName, objectId);
        if (inner != null) {
            return new ActiveDirectoryAdministratorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ActiveDirectoryAdministrator> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ActiveDirectoryAdministratorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ActiveDirectoryAdministratorImpl((ActiveDirectoryAdministratorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ActiveDirectoryAdministrator> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ActiveDirectoryAdministratorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ActiveDirectoryAdministratorImpl((ActiveDirectoryAdministratorInner)((Object)inner1), this.manager()));
    }

    @Override
    public ActiveDirectoryAdministrator getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = Utils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        return (ActiveDirectoryAdministrator)this.getWithResponse(resourceGroupName, serverName, objectId, Context.NONE).getValue();
    }

    @Override
    public Response<ActiveDirectoryAdministrator> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = Utils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, objectId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = Utils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        this.delete(resourceGroupName, serverName, objectId, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = Utils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        this.delete(resourceGroupName, serverName, objectId, context);
    }

    private AdministratorsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ActiveDirectoryAdministratorImpl define(String name) {
        return new ActiveDirectoryAdministratorImpl(name, this.manager());
    }
}

