/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerPropertiesForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ServerForUpdate {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="identity")
    private UserAssignedIdentity identity;
    @JsonProperty(value="properties")
    private ServerPropertiesForUpdate innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public ServerForUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public ServerForUpdate withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ServerPropertiesForUpdate innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerForUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerForUpdate withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    public ServerForUpdate withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    public ServerForUpdate withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ServerForUpdate withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public ServerForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public AuthConfig authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    public ServerForUpdate withAuthConfig(AuthConfig authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    public ServerForUpdate withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    public CreateModeForUpdate createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ServerForUpdate withCreateMode(CreateModeForUpdate createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerForUpdate withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

