// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationListFilter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceForPatch;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in MigrationsClient.
 */
public interface MigrationsClient {
    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MigrationResourceInner>> createWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceInner parameters);

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MigrationResourceInner> createAsync(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceInner parameters);

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MigrationResourceInner> createWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceInner parameters, Context context);

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MigrationResourceInner create(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceInner parameters);

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MigrationResourceInner>> getWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName);

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MigrationResourceInner> getAsync(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName);

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MigrationResourceInner> getWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, Context context);

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MigrationResourceInner get(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName);

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MigrationResourceInner>> updateWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceForPatch parameters);

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MigrationResourceInner> updateAsync(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceForPatch parameters);

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MigrationResourceInner> updateWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceForPatch parameters, Context context);

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MigrationResourceInner update(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceForPatch parameters);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, Context context);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter, Context context);
}
