// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for PostgreSqlManagementClient class.
 */
public interface PostgreSqlManagementClient {
    /**
     * Gets The ID of the target subscription. The value must be an UUID.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the AdministratorsClient object to access its operations.
     * 
     * @return the AdministratorsClient object.
     */
    AdministratorsClient getAdministrators();

    /**
     * Gets the BackupsClient object to access its operations.
     * 
     * @return the BackupsClient object.
     */
    BackupsClient getBackups();

    /**
     * Gets the LocationBasedCapabilitiesClient object to access its operations.
     * 
     * @return the LocationBasedCapabilitiesClient object.
     */
    LocationBasedCapabilitiesClient getLocationBasedCapabilities();

    /**
     * Gets the ServerCapabilitiesClient object to access its operations.
     * 
     * @return the ServerCapabilitiesClient object.
     */
    ServerCapabilitiesClient getServerCapabilities();

    /**
     * Gets the CheckNameAvailabilitiesClient object to access its operations.
     * 
     * @return the CheckNameAvailabilitiesClient object.
     */
    CheckNameAvailabilitiesClient getCheckNameAvailabilities();

    /**
     * Gets the CheckNameAvailabilityWithLocationsClient object to access its operations.
     * 
     * @return the CheckNameAvailabilityWithLocationsClient object.
     */
    CheckNameAvailabilityWithLocationsClient getCheckNameAvailabilityWithLocations();

    /**
     * Gets the ConfigurationsClient object to access its operations.
     * 
     * @return the ConfigurationsClient object.
     */
    ConfigurationsClient getConfigurations();

    /**
     * Gets the DatabasesClient object to access its operations.
     * 
     * @return the DatabasesClient object.
     */
    DatabasesClient getDatabases();

    /**
     * Gets the FirewallRulesClient object to access its operations.
     * 
     * @return the FirewallRulesClient object.
     */
    FirewallRulesClient getFirewallRules();

    /**
     * Gets the ServersClient object to access its operations.
     * 
     * @return the ServersClient object.
     */
    ServersClient getServers();

    /**
     * Gets the FlexibleServersClient object to access its operations.
     * 
     * @return the FlexibleServersClient object.
     */
    FlexibleServersClient getFlexibleServers();

    /**
     * Gets the LtrBackupOperationsClient object to access its operations.
     * 
     * @return the LtrBackupOperationsClient object.
     */
    LtrBackupOperationsClient getLtrBackupOperations();

    /**
     * Gets the MigrationsClient object to access its operations.
     * 
     * @return the MigrationsClient object.
     */
    MigrationsClient getMigrations();

    /**
     * Gets the ResourceProvidersClient object to access its operations.
     * 
     * @return the ResourceProvidersClient object.
     */
    ResourceProvidersClient getResourceProviders();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the GetPrivateDnsZoneSuffixesClient object to access its operations.
     * 
     * @return the GetPrivateDnsZoneSuffixesClient object.
     */
    GetPrivateDnsZoneSuffixesClient getGetPrivateDnsZoneSuffixes();

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionsClient object.
     */
    PrivateEndpointConnectionsClient getPrivateEndpointConnections();

    /**
     * Gets the PrivateEndpointConnectionOperationsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionOperationsClient object.
     */
    PrivateEndpointConnectionOperationsClient getPrivateEndpointConnectionOperations();

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     * 
     * @return the PrivateLinkResourcesClient object.
     */
    PrivateLinkResourcesClient getPrivateLinkResources();

    /**
     * Gets the ReplicasClient object to access its operations.
     * 
     * @return the ReplicasClient object.
     */
    ReplicasClient getReplicas();

    /**
     * Gets the LogFilesClient object to access its operations.
     * 
     * @return the LogFilesClient object.
     */
    LogFilesClient getLogFiles();

    /**
     * Gets the ServerThreatProtectionSettingsClient object to access its operations.
     * 
     * @return the ServerThreatProtectionSettingsClient object.
     */
    ServerThreatProtectionSettingsClient getServerThreatProtectionSettings();

    /**
     * Gets the VirtualEndpointsClient object to access its operations.
     * 
     * @return the VirtualEndpointsClient object.
     */
    VirtualEndpointsClient getVirtualEndpoints();

    /**
     * Gets the VirtualNetworkSubnetUsagesClient object to access its operations.
     * 
     * @return the VirtualNetworkSubnetUsagesClient object.
     */
    VirtualNetworkSubnetUsagesClient getVirtualNetworkSubnetUsages();
}
